import BaseACTION from '@/action/base_action'
import { Login } from '../api'

export default class LoginAction extends BaseACTION {
  /**
   * 当前登录用户，检测是否该系统有权限
   */
  getInfo () { return Login.getInfo().then(res => res) }
  /**
   * 调用登录接口
   */
  userLogin (obj) {
    return Login.userLogin(obj).then(res => {
      if (res && res.url === undefined) {
        console.log(webConf.others.url)
        res.url = webConf.others.url || ''
      }
      return res
    })
  }

  /**
   * 调用验证码登录
   */
  codeLogin (obj) {
    return Login.codeLogin(obj).then(res => {
      if (res && res.url === undefined) {
        res.url = webConf.others.url || ''
      }
      return res
    })
  }

  /* 调用退出登录接口 */
  outLogin () { return Login.outLogin().then(res => res) }
  /**
   * 调用获取验证码
   */
  sendCode (obj) { return Login.sendCode(obj).then(res => res) }
  /**
   * 调用发送重置密码验证码
   */
  sendResetPwdCode (obj) { return Login.sendResetPwdCode(obj).then(res => res) }
  /**
   * 调用重置密码验证码确认
   */
  validateCode (obj) { return Login.validateCode(obj).then(res => res) }
  /**
   * 调用重置密码
   */
  resetPwd (obj) { return Login.resetPwd(obj).then(res => res) }
  /**
   * 清空cookies
   */
  clearCookies (obj) { return Login.clearCookies(obj).then(res => res) }
}
