import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

// 获取事务类型列表
export function getAffairType() {
  return httpRequest.get('/api/lms/v2/lobby/affairs')
}
// 获取事务列表
export function getAffairList() {
  return httpRequest.get('/api/lms/v2/lobby/processes')
}
// 获取事务详情
export function getAffair(id) {
  return httpRequest.get(`/api/lms/v2/lobby/processes/${id}`)
}
// 创建事务
export function createAffair(data) {
  return httpRequest.post('/api/lms/v2/lobby/processes', data)
}
// 更新事务
export function updateAffair(id, data) {
  return httpRequest.post(`/api/lms/v2/lobby/processes/${id}`, data)
}
// 删除事务
export function deleteAffair(id) {
  return httpRequest({
    url: `/api/lms/v2/lobby/processes/${id}`,
    method: 'delete'
  })
}
// 上传文件
export function upload(data) {
  return httpRequest({
    url: '/api/lms/v2/lobby/tools/upload',
    method: 'post',
    headers: { 'Content-Type': 'multipart/form-data' },
    data
  })
}
// 获取学期
export function getSemesters(params) {
  return httpRequest.get('/api/lms/v2/lobby/semesters')
}
// 获取课程
export function getCourses(sid) {
  return httpRequest.get(`/api/lms/v2/lobby/semesters/${sid}/courses`)
}
// 获取成绩单
export function getReport() {
  return httpRequest.get('/api/lms/v2/lobby/havereport')
}
// 获取学生
export function getStudent() {
  return httpRequest.get('/api/lms/v2/lobby/student')
}
