import { isFunction } from 'lodash'
import * as api from '../api'

export default {
  props: {
    isEdit: { type: Boolean, default: false },
    isView: { type: Boolean, default: false }
  },
  data() {
    return {
      detail: {},
      // 学期列表
      semesterList: [
        { value: '春季学期（4月11日---7月10日）' },
        { value: '夏季学期（7月11日---10月10日）' },
        { value: '秋季学期（10月11日---1月10日）' },
        { value: '冬季学期（1月11日---4月10日）' }
      ],
      payList: [
        { label: '微信支付', value: '2' },
        { label: '支付宝支付', value: '1' },
        { label: '银行转账', value: '3' }
      ],
      submitLoading: false
    }
  },
  computed: {
    pid() {
      return this.$route.params.id
    },
    affairId() {
      return this.$route.query.id
    },
    // 撤回
    hasAbort() {
      return this.isEdit && this.detail.status === -1
    },
    // 去支付
    hasPay() {
      return this.isEdit && this.detail.pay === 0
    },
    // 已支付
    isPaid() {
      return this.detail.pay === 1
    },
    // 禁用信息部分
    disabledInfo() {
      return this.hasPay || this.isView || (this.isEdit && this.detail.status !== -1)
    },
    // 审批状态
    statusText() {
      const map = {
        '-1': '待审批',
        0: '未通过',
        1: '审批通过',
        2: '审批中'
      }
      return map[this.detail.status]
    },
    // 支付方式
    payText() {
      const map = {
        1: '支付宝支付',
        2: '微信支付',
        3: '银行转账'
      }
      return map[this.ruleForm.payment]
    },
    // 支付状态
    payStatusText() {
      const map = {
        '-1': '无',
        0: '待支付',
        1: '支付成功'
      }
      return map[this.detail.pay]
    }
  },
  methods: {
    // 获取学生信息
    getStudent() {
      api.getStudent().then(response => {
        const data = this.$_.pick(response, ['personal_name', 'class_name', 'sofia_id'])
        data.sofia_id = data.sofia_id || response.sno
        Object.assign(this.ruleForm, data)
      })
    },
    // 获取详情
    getDetail() {
      api.getAffair(this.pid).then(response => {
        this.detail = response
        this.ruleForm = response.form
      })
    },
    // 返回
    goBack() {
      this.$router.push({ path: '/app/offices', query: { id: this.affairId } })
    },
    // 提交
    handleSubmit(callback) {
      this.$refs.ruleForm.validate().then(() => {
        const params = Object.assign({}, this.ruleForm, { affair_id: this.affairId })
        this.isEdit ? this.handleUpdate(params, callback) : this.handleAdd(params, callback)
      })
    },
    // 新建
    handleAdd(params, callback) {
      this.submitLoading = true
      api
        .createAffair(params)
        .then(response => {
          if (response.success) {
            isFunction(callback) ? callback(response) : this.handleSuccess(response)
          } else {
            this.handleError(response)
          }
        })
        .catch(this.handleError)
        .finally(() => {
          this.submitLoading = false
        })
    },
    // 修改
    handleUpdate(params, callback) {
      this.submitLoading = true
      api
        .updateAffair(this.pid, params)
        .then(response => {
          if (response.success) {
            isFunction(callback) ? callback(response) : this.handleSuccess(response)
          } else {
            this.handleError(response)
          }
        })
        .catch(this.handleError)
        .finally(() => {
          this.submitLoading = false
        })
    },
    // 撤销的时候
    onRemove() {
      this.$confirm('你确定要撤回申请吗？撤回后，需要重新提交申请并由教务审批。', {
        confirmButtonText: '确定',
        cancelButtonText: '取消'
      }).then(this.handleRemove)
    },
    // 撤回申请
    handleRemove() {
      api.deleteAffair(this.pid).then(response => {
        if (response.success) {
          this.$message({ type: 'success', message: '撤回成功' })
          this.$router.replace({ path: '/app/offices', query: { id: this.affairId } })
        }
      })
    },
    // 成功
    handleSuccess(response) {
      this.$message({ type: 'success', message: response.message })
      this.$router.push({ path: '/app/offices', query: { id: this.affairId } })
    },
    // 失败
    handleError(response) {
      this.$message({ type: 'error', message: response.message })
    }
  }
}
