import TableList from '@/components/comTable/tableList'
import * as api from '../api'

export default {
  props: { affairId: { type: String, required: true } },
  components: { TableList },
  data() {
    return {
      remote: {
        request: api.getAffairList,
        params: { offset: 1 },
        beforeRequest: this.tableListbeforeRequest
      }
    }
  },
  methods: {
    // 列表接口请求之前
    tableListbeforeRequest(params) {
      params.affair_id = this.affairId
      return params
    },
    // 删除
    handleRemove(row) {
      api.deleteAffair(row.id).then(response => {
        if (response.success) {
          this.$message({ type: 'success', message: '删除成功' })
          // 刷新列表，强刷新，返回第一页
          this.$refs.tableList && this.$refs.tableList.refersh(true)
        }
      })
    },
    // 撤销
    handleCancel(row) {
      api.deleteAffair(row.id).then(response => {
        if (response.success) {
          this.$message({ type: 'success', message: '撤销成功' })
          // 刷新列表，强刷新，返回第一页
          this.$refs.tableList && this.$refs.tableList.refersh(true)
        }
      })
    }
  }
}
