import BaseAPI from '../base_api'
import _ from 'lodash'

export default class LoginAPI extends BaseAPI {
  /**
   * 调用登录接口
   * @param {[string]} obj.login_name 用户名
   * @param {[string]} obj.password 密码 md5加密
   * @param {[string]} obj.service 这里 一直是定值 web.ezijing.com
   */
  userLogin = (obj = {}) => this.post('/user_center/login', _.assignIn(obj, { service: 'web.ezijing.com' }), { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 调用退出登录
   * @param {[string]} obj.service 这里 一直是定值 web.ezijing.com
   */
  outLogin = (obj = {}) => this.post('/user_center/logout', _.assignIn(obj, { service: 'web.ezijing.com' }), { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 当前登录用户，检测是否该系统有权限
   * /user_center/get_user_info
   */
  getInfo = () => this.post('/user_center/get_user_info', {}, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 发送验证码
   * @param {[string]} obj.mobile 手机号
   * @param {[string]} obj.service 这里 一直是定值 web.ezijing.com
   */
  sendCode = (obj = {}) => this.post('/user_center/send_login_code', _.assignIn(obj, { service: 'web.ezijing.com' }), { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 验证码登录
   * @param {[string]} obj.mobile 手机号
   * @param {[string]} obj.code 验证码
   * @param {[string]} obj.service 这里 一直是定值 web.ezijing.com
   */
  codeLogin = (obj = {}) => this.post('/user_center/code_login', _.assignIn(obj, { service: 'web.ezijing.com' }), { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 发送重置密码验证码
   * @param {[string]} obj.contact 手机号/邮箱
   * @param {[string]} obj.source_type 值 3
   * @param {[string]} obj.service 这里 一直是定值 web.ezijing.com
   */
  sendResetPwdCode = (obj = {}) => this.post('/user_center/send_reset_password_code', _.assignIn(obj, { service: 'web.ezijing.com' }), { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 重置密码验证码确认
   * @param {[string]} obj.contact 手机号/邮箱
   * @param {[string]} obj.code 验证码
   * @param {[string]} obj.service 这里 一直是定值 web.ezijing.com
   */
  validateCode = (obj = {}) => this.post('/user_center/validate_code', _.assignIn(obj, { service: 'web.ezijing.com' }), { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 重置密码
   * @param {[string]} obj.contact 手机号/邮箱
   * @param {[string]} obj.code 验证码
   * @param {[string]} obj.new_password 新的密码
   * @param {[string]} obj.service 这里 一直是定值 web.ezijing.com
   */
  resetPwd = (obj = {}) => this.post('/user_center/reset_password', _.assignIn(obj, { service: 'web.ezijing.com' }), { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 个人信息 - 修改密码
   * @param {[string]} obj.old_password 验证码
   * @param {[string]} obj.new_password 新的密码
   * @param {[string]} obj.service 这里 一直是定值 web.ezijing.com
   */
  updatePwd = (obj = {}) => this.post('/user_center/change_password', _.assignIn(obj, { service: 'web.ezijing.com' }), { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 个人信息 - 上传头像
   */
  updatePic = (obj = {}) => this.post('/v3/storage/upload/avatar', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
}
