
export default [
  { path: '/', redirect: '/app/learn/course' },
  {
    path: '/login/index',
    name: 'login-normal',
    component: () => import('@/pages/login/index.vue'),
    props: (route) => ({ query: route.query, params: route.params })
  },
  {
    path: '/login/code',
    name: 'login-code',
    component: () => import('@/pages/login/code.vue'),
    props: (route) => ({ query: route.query, params: route.params })
  },
  {
    path: '/login/forget',
    name: 'login-forget',
    component: () => import('@/pages/login/forget.vue'),
    props: (route) => ({ query: route.query, params: route.params })
  },
  /* App 内登录页面未找到时 - 指向 */
  { path: '/login/*', redirect: '/login/index' },
  /* 学习系统 - 登录后，进入页面 */
  {
    path: '/app',
    redirect: '/app/error/404',
    component: () => import('@/pages/mainsite.vue'),
    children: [
      { path: 'error/404', component: () => import('@/components/errorPages/404.vue') },
      {
        path: 'other',
        redirect: 'error/404',
        component: () => import('@/components/learnSysLayout/container.vue'),
        children: [
          { path: 'message', component: () => import('../pages/other/message.vue') },
          { path: 'set-pwd', component: () => import('../pages/other/setPwd.vue') },
          { path: 'update-pic', component: () => import('../pages/other/updatePic.vue') }
        ]
      },
      {
        path: 'learn',
        redirect: 'error/404',
        component: () => import('@/components/learnSysLayout/container.vue'),
        children: [
          { path: 'course', component: () => import('../pages/learn/course.vue') },
          { path: 'course-all', component: () => import('../pages/learn/courseAll.vue') },
          { path: 'course-detail/:cid', component: () => import('../pages/learn/courseDetail.vue'), props: true },
          { path: 'discuss-detail/:cid/:id', component: () => import('../pages/learn/discussDetail.vue'), props: true },
          { path: 'discussion', component: () => import('../pages/learn/discussion.vue') }
          // { path: 'report-list', component: () => import('../pages/learn/reportList.vue') },
          // { path: 'report-active-list', component: () => import('../pages/learn/reportActiveList.vue') },
          // { path: 'report-list-all/:rid', component: () => import('../pages/learn/reportListAll.vue'), props: true },
          // { path: 'report-add/:rid', component: () => import('../pages/learn/reportAdd.vue'), props: true },
          // { path: 'report-submit/:rid/:reid', component: () => import('../pages/learn/reportSubmit.vue'), props: true }
        ]
      },
      // {
      //   path: 'grade',
      //   redirect: 'error/404',
      //   component: () => import('@/components/learnSysLayout/container.vue'),
      //   children: [
      //     { path: 'credit', component: () => import('../pages/grade/credit.vue') },
      //     { path: 'rebuild', component: () => import('../pages/grade/rebuild.vue') }
      //   ]
      // },
      {
        path: 'feedback',
        redirect: 'error/404',
        component: () => import('@/components/learnSysLayout/container.vue'),
        children: [
          // { path: 'set-pwd', component: () => import('../pages/account/setPwd.vue') },
          // { path: 'update-pic', component: () => import('../pages/account/updatePic.vue') },
          { path: 'feedback-list', component: () => import('../pages/feedback/feedbackList.vue') },
          { path: 'feedback-create', component: () => import('../pages/feedback/feedbackCreate.vue') }
        ]
      // },
      // {
      //   path: 'service-hall',
      //   redirect: 'error/404',
      //   component: () => import('@/components/learnSysLayout/container.vue'),
      //   children: [
      //     // { path: 'hall', component: () => import('../pages/serviceHall/hall.vue') },
      //     // { path: 'learning-add/:rid', component: () => import('../pages/serviceHall/learningAdd.vue'), props: true },
      //     // { path: 'share-add/:rid', component: () => import('../pages/serviceHall/shareAdd.vue'), props: true },
      //     // { path: 'again-add/:rid', component: () => import('../pages/serviceHall/againAdd.vue'), props: true },
      //     // { path: 'my-apply', component: () => import('../pages/serviceHall/myApply.vue'), props: true },
      //     // { path: 'upload-report/:rid/:reid', component: () => import('../pages/serviceHall/uploadReport.vue'), props: true },
      //     // { path: 'view-report/:rid', component: () => import('../pages/serviceHall/viewReport.vue'), props: true }
      //   ]
      }
    ]
  },
  /* 学习系统 - player */
  {
    path: '/player/:cid',
    redirect: '/player/0/error/404',
    component: () => import('@/pages/player/index.vue'),
    props: true,
    children: [
      { path: 'error/404', component: () => import('@/components/errorPages/404.vue') },
      {
        path: 'chapter-video/:id/:videoType',
        name: 'video',
        component: () => import('@/pages/player/chapterVideo/chapterVideo.vue'),
        props: true
      },
      {
        path: 'chapter-exam/:id',
        name: 'chapterExam',
        component: () => import('@/pages/player/chapterExam/chapterExam.vue'),
        props: true
      },
      {
        path: 'chapter-read/:id',
        name: 'chapterRead',
        component: () => import('@/pages/player/chapterRead/chapterRead.vue'),
        props: true
      },
      {
        path: 'chapter-work/:id',
        name: 'chapterWork',
        component: () => import('@/pages/player/chapterWork/chapterWork.vue'),
        props: true
      },
      {
        path: 'course-info/:id',
        name: 'courseInfo',
        component: () => import('@/pages/player/courseInfo/courseInfo.vue'),
        props: true
      },
      {
        path: 'course-work/:id',
        name: 'courseWork',
        component: () => import('@/pages/player/courseWork/courseWork.vue'),
        props: true
      },
      {
        path: 'exam/:id',
        name: 'exam',
        component: () => import('@/pages/player/exam/exam.vue'),
        props: true
      },
      {
        path: 'live/:id',
        name: 'live',
        component: () => import('@/pages/player/live/live.vue'),
        props: true
      }
    ]
  },
  /* mobileLive 移动端 */
  {
    path: '/mobile',
    redirect: '/mobile/0/0/error/404',
    component: () => import('@/pages/mobileLive/index.vue'),
    props: true,
    children: [
      { path: 'error/404', component: () => import('@/components/errorPages/404.vue') },
      {
        path: 'list',
        name: 'list',
        component: () => import('@/pages/mobileLive/list.vue'),
        props: true
      },
      {
        path: 'help/student',
        name: 'studentHelp',
        component: () => import('@/pages/mobileLive/studentHelp.vue')
      },
      {
        path: 'help/teacher',
        name: 'teacherHelp',
        component: () => import('@/pages/mobileLive/teacherHelp.vue')
      }
    ]
  },
  // {
  //   path: '/survey/:sid/:cid',
  //   name: 'survey',
  //   component: () => import('../../components/survey/survey.vue'),
  //   props: true
  // },
  // /* survey 内未找到页面时 - 指向 */
  // { path: '/survey/*', redirect: '/learn-error/learn-error' },
  // {
  //   path: '/survey-phone/:sid/:cid',
  //   name: 'survey-phone',
  //   component: () => import('../../components/survey/surveyPhone.vue'),
  //   props: true
  // },
  // /* survey-phone 内未找到页面时 - 指向 */
  // { path: '/survey-phone/*', redirect: '/learn-error/learn-error' },
  /* 如果所有页面都没找到 - 指向 */
  { path: '*', component: () => import('@/components/errorPages/404.vue') }
]
