import BaseAPI from './base_api'
import _ from 'lodash'

export default class OtherAPI extends BaseAPI {
  /**
   * 当前登录用户，检测是否该系统有权限
   */
  getInfo = () => this.get('/api/lms/user/getinfo')

  /**
   * 获取我的消息信息
   */
  getMyMsg = (obj) => this.get('/api/lms/v2/education/message/my', obj, {})
  /**
   * 标记已读未读
   */
  setMyMsg = (rid) => this.post(`/api/lms/v2/education/message/${rid}`, {})

  getNavMsg = (rid) =>
    this.get(`/api/lms/v2/education/message/num?v=${new Date().getTime()}`, {})

  /**
   * 调用退出登录
   */
  outLogin = () => this.get('/api/passport/rest/logout')

  /**
   * 文件提交
   * @param {[object]} obj
   */
  uploadFile = (obj = {}) =>
    this.post('/api/lms/util/upload-file', obj, {
      headers: { 'Content-Type': 'multipart/form-data' }
    })

  /**
   * 个人信息 - 修改密码
   * @param {[string]} obj.old_password 验证码
   * @param {[string]} obj.new_password 新的密码
   * @param {[string]} obj.service 这里 一直是定值 h5.ezijing.com
   */
  updatePwd = (obj = {}) =>
    this.post(
      '/api/usercenter/user/change-pwd-by-cookie',
      _.assignIn(obj, { service: 'h5.ezijing.com' }),
      { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } }
    )

  /**
   * 个人信息 - 上传头像
   */
  updateUser = (obj = {}) =>
    this.post('/api/usercenter/user/update-user', obj, {
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
    })
}
