import BaseAPI from '../base_api'

export default class ExamAPI extends BaseAPI {
  /**
   * 获取考卷信息
   * @param {[string]} course_id -> cid
   * @param {[string]} semester_id -> sid
   */
  getExamInfo = (cid, sid) => this.get(`/v2/education/${sid}/${cid}/examination`, {})
  /**
   * 获取考卷结果
   * @param {[string]} course_id -> cid
   * @param {[string]} semester_id -> sid
   * @param {[string]} exam_id -> eid
   */
  getExamAnswer = (cid, sid, eid) => this.get(`/v2/education/${sid}/${cid}/examination/${eid}/sheet`, {})
  /**
   * 获取考试状态
   * @param {[string]} course_id -> cid
   * @param {[string]} semester_id -> sid
   * @param {[string]} exam_id -> eid
   */
  getExamStatus = (cid, sid, eid) => this.get(`/v2/education/${sid}/${cid}/examination/${eid}/status`, {})
  /**
   * 提交考卷
   * @param {[string]} course_id -> cid
   * @param {[string]} semester_id -> sid
   * @param {[string]} exam_id -> eid
   * @param {[object]} obj -> 提交对象类
   */
  submitExam = (cid, sid, eid, obj = {}) => this.post(`/v2/education/${sid}/${cid}/examination/${eid}/sheet`, obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
}
