import ActivityEdit from './src/activity/edit.vue'
import ShareEdit from './src/share/edit.vue'
import RetakEdit from './src/retake/edit.vue'
import PareportEdit from './src/reportPaper/edit.vue'
import ElreportEdit from './src/reportE/edit.vue'
import PauseStudyEdit from './src/studyPause/edit.vue'
import ContinueStudyEdit from './src/studyContinue/edit.vue'
import SchoolCertEdit from './src/certSchool/edit.vue'
import StudyCertEdit from './src/certStudy/edit.vue'
import GraduationEdit from './src/graduation/edit.vue'

export default [
  {
    path: '/app/offices',
    component: () => import('@/pages/mainsite.vue'),
    children: [
      { path: '', component: () => import(/* webpackChunkName: "offices" */ './src/index.vue') },

      /**
       * 学术活动
       */
      { name: 'activityAdd', path: 'activity/add', component: ActivityEdit },
      { name: 'activityEdit', path: 'activity/edit/:id', component: ActivityEdit, props: { isEdit: true } },
      { name: 'activityView', path: 'activity/view/:id', component: ActivityEdit, props: { isView: true } },
      {
        name: 'activityReportView',
        path: 'activity/report',
        component: () => import(/* webpackChunkName: "offices" */ './src/activity/reportView.vue')
      },
      {
        name: 'activityReportEdit',
        path: 'activity/report/edit',
        component: () => import(/* webpackChunkName: "offices" */ './src/activity/reportEdit.vue')
      },

      /**
       * 乐分享
       */
      { name: 'shareAdd', path: 'share/add', component: ShareEdit },
      { name: 'shareEdit', path: 'share/edit/:id', component: ShareEdit, props: { isEdit: true } },
      { name: 'shareView', path: 'share/view/:id', component: ShareEdit, props: { isView: true } },

      /**
       * 重修
       */
      { name: 'retakeAdd', path: 'retake/add', component: RetakEdit },
      { name: 'retakeEdit', path: 'retake/edit/:id', component: RetakEdit, props: { isEdit: true } },
      { name: 'retakeView', path: 'retake/view/:id', component: RetakEdit, props: { isView: true } },

      /**
       * 纸质成绩单
       */
      { name: 'pareportAdd', path: 'pareport/add', component: PareportEdit },
      { name: 'pareportEdit', path: 'pareport/edit/:id', component: PareportEdit, props: { isEdit: true } },
      { name: 'pareportView', path: 'pareport/view/:id', component: PareportEdit, props: { isView: true } },

      /**
       * 电子成绩单
       */
      { name: 'elreportAdd', path: 'elreport/add', component: ElreportEdit },
      { name: 'elreportEdit', path: 'elreport/edit/:id', component: ElreportEdit, props: { isEdit: true } },
      { name: 'elreportView', path: 'elreport/view/:id', component: ElreportEdit, props: { isView: true } },

      /**
       * 休学
       */
      { name: 'pauseStudyAdd', path: 'pause_study/add', component: PauseStudyEdit },
      { name: 'pauseStudyEdit', path: 'pause_study/edit/:id', component: PauseStudyEdit, props: { isEdit: true } },
      { name: 'pauseStudyView', path: 'pause_study/view/:id', component: PauseStudyEdit, props: { isView: true } },

      /**
       * 复学
       */
      { name: 'continueStudyAdd', path: 'continue_study/add', component: ContinueStudyEdit },
      {
        name: 'continueStudyEdit',
        path: 'continue_study/edit/:id',
        component: ContinueStudyEdit,
        props: { isEdit: true }
      },
      {
        name: 'continueStudyView',
        path: 'continue_study/view/:id',
        component: ContinueStudyEdit,
        props: { isView: true }
      },

      /**
       * Sofia在读证明
       */
      { name: 'schoolCertAdd', path: 'school_cret/add', component: SchoolCertEdit },
      { name: 'schoolCertEdit', path: 'school_cret/edit/:id', component: SchoolCertEdit, props: { isEdit: true } },
      { name: 'schoolCertView', path: 'school_cret/view/:id', component: SchoolCertEdit, props: { isView: true } },

      /**
       * 紫荆在读证明
       */
      { name: 'studyCertAdd', path: 'study_cret/add', component: StudyCertEdit },
      { name: 'studyCertEdit', path: 'study_cret/edit/:id', component: StudyCertEdit, props: { isEdit: true } },
      { name: 'studyCertView', path: 'study_cret/view/:id', component: StudyCertEdit, props: { isView: true } },
      /**
       * 毕业典礼
       */
      { name: 'graduationAdd', path: 'graduation/add', component: GraduationEdit },
      { name: 'graduationEdit', path: 'graduation/edit/:id', component: GraduationEdit, props: { isEdit: true } },
      { name: 'graduationView', path: 'graduation/view/:id', component: GraduationEdit, props: { isView: true } }
    ]
  }
]
