const gulp = require('gulp')
const gulpZip = require('gulp-zip')
const clean = require('gulp-clean')
const gulpSequence = require('gulp-sequence')

const conf = {
  BASE_URL: '../'
}
gulp.task('default', function (cb) {
  gulpSequence('staticToClientDist', 'zipBefore', 'zip', 'zipAfter', cb)
})
gulp.task('staticToClientDist', function () {
  return gulp.src(conf.BASE_URL + 'static/**/*').pipe(gulp.dest(conf.BASE_URL + 'client-dist/static/'))
})

gulp.task('zipBefore', function () {
  gulp.src(conf.BASE_URL + 'server/**/*').pipe(gulp.dest(conf.BASE_URL + 'dist/server'))
  gulp.src(conf.BASE_URL + 'package.json').pipe(gulp.dest(conf.BASE_URL + 'dist'))
  return gulp.src(conf.BASE_URL + 'client-dist/**/*').pipe(gulp.dest(conf.BASE_URL + 'dist/client-dist'))
})
gulp.task('zip', function () { return gulp.src(conf.BASE_URL + 'dist/**/*').pipe(gulpZip('build.zip')).pipe(gulp.dest(conf.BASE_URL)) })
gulp.task('zipAfter', function () { return gulp.src(conf.BASE_URL + 'dist/').pipe(clean({ force: true })) })
