import LoginAction from './LoginAction'
import ChapterAction from './ChapterAction'
import CourseAction from './CourseAction'
import DiscussAction from './DiscussAction'
import MsgAction from './MsgAction'
import ScoreAction from './ScoreAction'
import ReportAction from './ReportAction'

let loginAction = new LoginAction()
let chapterAction = new ChapterAction()
let courseAction = new CourseAction()
let discussAction = new DiscussAction()
let msgAction = new MsgAction()
let scoreAction = new ScoreAction()
let reportAction = new ReportAction()

const cAction = {
  loginAction,
  chapterAction,
  courseAction,
  discussAction,
  msgAction,
  scoreAction,
  reportAction
}

/**
 * 统一处理接口返回请求
 * 由于使用 axios ，返回 then + finally 可能存在 部分浏览器不支持情况
 * 需要 添加兼容
 * @param {[object]} obj 整个对象
 * @param {[object]} obj.component 当前调用组件对象 传过来，必传
 * @param {[string]} obj.actionName action名字，必传
 * @param {[string]} obj.functionName action类中的方法名，必传
 * @param {[object]} obj.data 传输数据，必传
 * @param {[function]} obj.thenCallback 异步成功返回回调值，必传
 * @param {[function]} obj.catchCallback 异常抛出时，返回错误抓取回调值，必传
 * @param {[function]} obj.finallyCallback 最终finally回调，必传
 */
export const request = (obj) => {
  cAction[obj.actionName][obj.functionName](obj.data).then(res => {
    obj.thenCallback(res)
  }).catch(e => {
    obj.component.$message.error(e.message)
    obj.catchCallback(e)
  }).finally(e => {
    obj.finallyCallback(e)
  })
}

export default cAction
