import BaseAPI from '../base_api'

export default class ScoreAPI extends BaseAPI {
  /**
   * 获取我的学术活动
   */
  getReportActiveList = () => this.get('/tenant/v2/education/symposium/my', {})
  /**
   * 获取学术活动详情
   */
  getReportActive = (aid) => this.get(`/tenant/v2/education/symposium/${aid}`, {})
  /**
   * 提交活动申请
   * symposium_name 活动名称
   * symposium_contents 活动内容
   * symposium_attachments 活动附件
   * symposium_time 活动时间
   * symposium_address 活动地点
   * symposium_lecturer 活动讲师
   * 返回 {'flag' : true, 'errors' : []}
   */
  submitReportActive = (obj = {}) => this.post('/tenant/v2/education/symposium', obj)
  /**
   * 修改活动申请
   * 参数同上
   */
  updateReportActive = (aid, obj = {}) => this.post(`/tenant/v2/education/symposium/${aid}`, obj)

  /**
   * 获取活动相关的学术报告
   */
  getReportList4 = () => this.get('/tenant/v2/education/symposium/<symposium_id>/report', {})
  /**
   * 获取所有通过报告列表
   */
  getReportList = () => this.get('/tenant/v2/education/symposium-report-all', {})
  /**
   * 提交学术报告
   * report_name 报告名称
   * report_description 报告描述
   * file_url 文章URL
   */
  getReportList5 = (aid, obj = {}) => this.post(`/tenant/v2/education/symposium/${aid}/report`, obj)
  /**
   * 更新学术报告
   */
  getReportList6 = () => this.post('/tenant/v2/education/symposium/<symposium_id>/report/<report_id>', {})
}
