/**
 * 工具方法 - 日期时间 转化 y-m-d
 * @param {[string]} timestamp 时间戳
 * @param {[string]} separator 分隔符，默认 “-”
 */
const timestampToFormatDateStr = (timestamp, separator) => {
  separator = separator || '-'
  let y = new Date(timestamp).getFullYear()
  let m = new Date(timestamp).getMonth() + 1
  if (m < 10) {
    m = '0' + m
  } else {
    m = m + ''
  }
  let d = new Date(timestamp).getDate()
  if (d < 10) {
    d = '0' + d
  } else {
    d = d + ''
  }
  return [y, m, d].join(separator)
}
/**
 * 工具方法 - 播放时间 转化 h:m:s
 * @param {[string]} timestamp 时间戳
 * @param {[string]} separator 分隔符，默认 “:”
 */
const timestampToFormatTimeStr = (timestamp, separator) => {
  separator = separator || ':'
  timestamp = Math.floor(timestamp / 1000)
  let h = Math.floor(timestamp / 3600)
  let m = Math.floor((timestamp - h * 3600) / 60)
  let s = (timestamp - h * 3600 - m * 60) % 60
  function tenify (a) {
    return a >= 10 ? a : '0' + a
  }
  let to = { h: tenify(h), m: tenify(m), s: tenify(s) }
  let format = ['h', 'm', 's'].join(separator)
  return format.replace(/h|m|s/g, k => to[k]).replace(/^00:/, '')
}

module.exports = {
  timestampToFormatDateStr: timestampToFormatDateStr,
  timestampToFormatTimeStr: timestampToFormatTimeStr
}
