const Router = require('express').Router
const router = Router()

const bodyParser = require('body-parser')
const multer = require('multer')
const upload = multer({ dest: 'upload_tmp/' })

const _ck = require('../controller/ckeditorMonitor')
const _dvm = require('../controller/DealVideoMonitor')
const _op = require('../controller/DirMonitor')
const _websocket = require('../controller/SocketMonitor')
const _proxy = require('../controller/ProxyMonitor')

router.use(bodyParser.json({ limit: '600kb' }))
router.use(bodyParser.urlencoded({ extended: true, limit: '600kb' }))

/* 统一API接口 */
router.post('/api/ckeditor/img/upload', upload.any(), _ck.ckeditorUpload)
router.post('/api/deal/video', upload.any(), _dvm.dealVideo)
router.post('/api/websocket/send-msg', upload.any(), _websocket.sendMsg)
router.post('/api/dir/send-msg', upload.any(), _op.dirOperate)
router.use('/api/*', upload.any(), _proxy.agentProcessor())

module.exports = router
