const path = require('path')
const webpack = require('webpack')
const projectName = process.env.PROJECT_NAME
const $GLOBAL = {
  isDev: process.env.NODE_ENV === 'development',
  serverPort: process.env.SERVER_PORT || 8000,
  RootPath: path.resolve(__dirname, '../'),
  templatePath: path.resolve(__dirname, ('../client/project/' + projectName + '/index.html')),
  icoPath: 'client/project/' + projectName + '/assets/favicon.ico',
  EntryPath: path.resolve(__dirname, ('../client/project/' + projectName + '/main.js')),
  OutputPath: path.resolve(__dirname, '../client-dist'),
  JsName: 'resources/[name].[chunkhash:8].js',
  cssName: 'resources/[name].[contenthash:12].css',
  ResPath: 'resources/[name].[hash:8].[ext]',
  BaseConfig: {},
  webConf: {
    'devDomain': 'http://api.ezijing.com',
    'apiBaseURL': '/api',
    'CDN_PATH': 'https://zws-imgs-pub.ezijing.com/static/build/learn-mba/'
  }
}

$GLOBAL.BaseConfig = {
  target: 'web',
  entry: $GLOBAL.EntryPath,
  output: {
    filename: $GLOBAL.JsName,
    path: $GLOBAL.OutputPath,
    publicPath: $GLOBAL.isDev ? '/' : $GLOBAL.webConf.CDN_PATH
  },
  resolve: {
    alias: {
      '@services': path.resolve(__dirname, '../client/components/services'),
      '@tools': path.resolve(__dirname, '../client/components/tools'),
      '@actions': path.resolve(__dirname, '../client/project/' + projectName + '/actions')
    }
  },
  module: {
    rules: [
      {
        test: /\.(vue|js|jsx)$/,
        loader: 'eslint-loader',
        exclude: /node_modules/,
        enforce: 'pre'
      },
      {
        test: /\.vue$/,
        loader: 'vue-loader'
      },
      {
        test: /(\.jsx|\.js)$/,
        exclude: /(node_modules)|(dist)/,
        loader: 'babel-loader',
        options: {
          presets: ['env', 'stage-2'],
          plugins: [
            'transform-vue-jsx',
            'syntax-dynamic-import'
          ]
        }
      },
      {
        test: /\.(png|jpe?g|gif|svg|ico)(\?.*)?$/,
        use: {
          loader: 'url-loader',
          options: {
            limit: 4096,
            name: $GLOBAL.ResPath
          }
        }
      },
      {
        test: /\.(mp4|webm|ogg|mp3|wav|flac|aac)(\?.*)?$/,
        loader: 'url-loader',
        options: {
          limit: 10000,
          name: $GLOBAL.ResPath
        }
      },
      {
        test: /\.(woff2?|eot|ttf|otf)(\?.*)?$/,
        loader: 'url-loader',
        options: {
          limit: 10000,
          name: $GLOBAL.ResPath
        }
      }
    ]
  },
  plugins: [
    new webpack.DefinePlugin({
      'webConf': JSON.stringify($GLOBAL.webConf)
    }),
    new webpack.ProvidePlugin({
      $: 'jquery',
      jQuery: 'jquery',
      'window.jQuery': 'jquery'
    })
  ],
  externals: {
    'CKEDITOR': 'window.CKEDITOR',
    'VideoJs': 'window.swfobject'
  }
}
module.exports = $GLOBAL
