import BaseAPI from '../base_api'

export default class ChapterAPI extends BaseAPI {
  /**
   * 获取章节列表信息
   * @param {[string]} cur_course_id -> cid
   * @param {[string]} cur_semester_id -> sid
   * @param {[string]} cur_video_id -> vid
   */
  getChapterList = (cid, sid, vid) => this.get(`/v2/education/courses/${sid}/${cid}`, {})
  /**
   * 获取对应某个章节的详细信息
   * @param {[string]} vid
   */
  getCurrentChapterDetail = (vid) => this.post('/v2/education/video-streaming', { vid })
  /**
   * 获取对应某个章节的详细信息
   * @param {[string]} vid
   */
  getCurrentChapterDetailAliyun = (vid) => this.post('/v2/education/aliyun-video-streaming', { vid })
  /**
   * 获取进度信息
   * @param {[string]} vid
   * @param {[string]} did
   * @param {[string]} sid
   */
  getProgress = (vid, did, sid) => this.get(`/v2/education/video/${sid}/${vid}/device`, { device_id: did })
  /**
   * 提交进度信息
   * @param {[object]} obj
   * d: obj.did,
      i: obj.did,
      c: obj.cid,
      s: obj.sid,
      v: obj.vid,
      _p: obj.pt, // 累计时间
      _m: obj.mpt, // 当前播放最大时间
      _c: obj.cpt // 当前播放位置
   */
  updateProgress = (obj = {}) => this.get('/v2/analytics/upload-video', obj)
  /**
   * 获取试题信息
   * @param {[string]} eid
   * @param {[string]} cid
   * @param {[string]} sid
   */
  getExamDetail = (sid, cid, eid) => this.get(`/v2/education/homeworks/${sid}/${cid}/${eid}`, {})
  /**
   * 提交考试信息
   * @param {[object]} param
   */
  submitExamDetail = (param) => this.post(`/v2/education/homeworks`, param)
  /**
   * 获取对应 作业或问题 回答
   * @param {[string]} sid
   * @param {[string]} cid
   * @param {[string]} id resource_id
   */
  getHomework = (sid, cid, id) => this.get(`/v2/education/homeworks/${sid}/${cid}/${id}`, {})
  /**
   * 文件提交
   * @param {[object]} obj
   */
  uploadFile = (obj = {}) => this.post('/util/upload-file', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
  /**
   * 提交课程 作业或问题
   */
  updateHomework = (obj = {}) => this.post('/v2/education/homeworks', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
  /**
   * 课程作业截止时间
   */
  getHomeworkStopTime = (sid, cid, chapterId) => this.get(`/v2/education/homeworks/${sid}/${cid}/${chapterId}/deadline`, {})
  /**
   * 获取对应 大作业 回答
   * @param {[string]} sid
   * @param {[string]} cid
   */
  getCourseHomework = (sid, cid) => this.get(`/v2/education/courses/${sid}/${cid}/essay`, {})
  /**
   * 提交课程 大作业
   * @param {[string]} sid
   * @param {[string]} cid
   */
  updateCourseHomework = (sid, cid, obj = {}) => this.post(`/v2/education/courses/${sid}/${cid}/essay`, obj, { headers: { 'Content-Type': 'multipart/form-data' } })
  /**
   * 提交 课程考核
   * @param {[string]} obj.sid
   * @param {[string]} obj.cid
   * @param {[string]} obj.raw (base64)
   */
  updateSurveyAnswer = (obj) => this.post(`/v2/education/survey/answer`, obj)
  /**
   * 手机端 获取实时最新直播接口
   */
  getNewLiveMsg = (obj = {}) => this.get(`/v2/education/lives/latest`, obj)
  /**
   * 手机端 获取列表接口
   */
  getLiveList = (obj = {}) => this.get(`/v2/education/lives/courses`, obj)
}
