import { scoreApi } from '@services'

/**
 * 小程序 跟 PC 区别
 * 1. PC 直接使用 then，小程序 需要 callback
 * 2. PC 直接返回 对象，小程序 外层再保证一次返回 { status: xxx, data: data }
 */

export default class ScoreAction {
  /* 获取我的学分信息 */
  getMyScore () {
    return scoreApi.getMyScore().then(res => {
      let _data = res
      let json = {
        total: _data.total_credits,
        myTotal: _data.my_total_credits,
        myTotalStr: (_data.total_credits && ((_data.my_total_credits * 1.0 / _data.total_credits * 100).toFixed(1) + '%')) || '0%',
        must: _data.required_credits,
        myMust: _data.my_required_credits,
        myMustStr: (_data.required_credits && ((_data.my_required_credits * 1.0 / _data.required_credits * 100).toFixed(1) + '%')) || '0%',
        unmust: _data.optional_credits,
        myUnmust: _data.my_optional_credits,
        myUnmustStr: (_data.optional_credits && ((_data.my_optional_credits * 1.0 / _data.optional_credits * 100).toFixed(1) + '%')) || '0%',
        list: _data.lists
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 提交重修 */
  rebuildSubmit (obj) { return scoreApi.submitRebuild(obj).then(res => res) }
  /* 意见反馈列表 */
  feedbackList (obj) { return scoreApi.feedbackList(obj).then(res => res) }
  /* 意见反馈回复 */
  feedbackReply (obj) { return scoreApi.feedbackReply(obj).then(res => res) }
  /* 意见反馈提交 */
  feedbackCommit (obj) { return scoreApi.feedbackCommit(obj).then(res => res) }
}
