## 组件简介

|  字段值  | 说明                       | 字段属性 | 默认值 |
| ------- | ------------------------- | ------- | ----- |
| `type`  | 类型：`String`; 说明：组件类型名 | 自定义字段 | `upload-form` |
| `action`  | 类型：`String`; 说明：上传请求接口path | 自定义字段 | `` |
| `deleteAction`  | 类型：`String`; 说明：删除请求接口path | 自定义字段 | `` |
| `html`  | 类型：`String`; 说明：上传说明，支持html | 自定义字段 | `` |
| `label` | 类型：`String`; 说明：组件左侧显示名称 | element-ui el-form-item对应字段 | `''` |
| `label-width` | 类型：`String`; 说明：组件左侧显示名称宽度（加单位），父级设置可以子级继承 | element-ui el-form-item对应字段 | `''` |
| `required` | 类型：`Boolean`; 说明：标识是否必填 | element-ui el-form-item对应字段 | `false` |
| `disabled` | 类型：`Boolean`; 说明：标识是否只读 | element-ui el-form-item对应字段 | `false` |
| `model` | 类型：`String`; 说明：表单提交name值和回显对照字段 | 自定义字段 | `''` |
| `placeholder` | 类型：`String`; 说明：组件input框中，默认提示文字 | element-ui el-input对应字段 | `''` |
| `attrs` | 类型：`Object`; 说明：定义标签上Data属性值 | element-ui对应字段 | `{}` |
| `rules` | 类型：`Array`; 说明：组件错误提示规则 | element-ui el-form-item对应字段 | `[]` |

### Demo Example:
``` js
return {
  type: 'upload-form',
  label: '姓名',
  labeWidth: '160px',
  required: true,
  disabled: false,
  model: 'uploadArrs',
  action: '',
  data: {

  },
  deleteAction: '',
  deleteData: {

  },
  html: `
    <div style="color: #72818c; font-size: 14px;">
      <p style="margin: 0;">申请者需要将有效身份证件原件扫描或者拍照后提交。</p>
      <p style="margin: 0;">请您提供有效身份证件的扫描件，身份证与台港澳居民大陆通行证应包括正反两面扫描件。</p>
      <p style="margin: 0;">只上传一个文件，多份文件需合并到一个文件后打印出来检查无误后再上传。</p>
      <p style="margin: 0;">上传文件仅限“jpg,jpeg,gif,png”格式，文件小于10MB。</p>
    </div>
  `,
  attrs: {
    multiple: false,
    limit: 1
  },
  rules: [
    {
      required: true,
      message: '请上传',
      trigger: 'blur'
    }
  ]
}
```

* 其他属性 [参考文档]([https://](https://element.eleme.cn/#/zh-CN/component/input))
