import cAction from '@actions'
// import cTool from '@tools'

export default class LoginInfo {
  /**
   * 是否存在 用户数据
   * 目的：判断是否需要登录
   */
  isLogin (Vue) {
    let _$ = Vue.prototype.$GlobalVariable
    /* _SUP 改为 服务端 设置，客户端 获取不到 */
    // let str = decodeURIComponent(cTool.cookies.getCookie('_SUP') || '')
    if (_$.UserInfo && _$.UserInfo.auth_key) {
      /* 是登录状态并且用户存在权限，可以跳转到对应页面 */
      return Promise.resolve('login-1')
    } else {
      return cAction.loginAction.getInfo().then(res => {
        if (res.auth_key) { /* 服务器，cookie时间未过期，可继续使用 */
          _$.UserInfo = res
          return 'login-2'
        } else { /* 需要重新登录页 */
          return 'nologin-1'
        }
      })
    }
  }
}
