import BaseACTION from './base_action'
import { Report } from '@api'

export default class ReportAction extends BaseACTION {
  /* 获取学术报告列表 */
  getReportList () { return Report.getReportList().then(res => res) }
  /* 获取学术活动列表 */
  getReportActiveList () { return Report.getReportActiveList().then(res => res) }
  /* 提交活动申请 */
  submitReportActive (obj) { return Report.submitReportActive(obj).then(res => res) }
  /* 获取活动详情 */
  getReportActive (rid) { return Report.getReportActive(rid).then(res => res) }
  /* 修改活动申请 */
  updateReportActive (rid, obj) { return Report.updateReportActive(rid, obj).then(res => res) }
  /* 删除活动申请 */
  deleteReportActive (rid) { return Report.deleteReportActive(rid).then(res => res) }
  /* 获取活动相关的学术报告 */
  getReportListAll (obj) { return Report.getReportListAll(obj.rid).then(res => res) }
  /* 提交学术报告 */
  submitReport (rid, obj) { return Report.submitReport(rid, obj).then(res => res) }
  /* 获取报告详情 */
  getSubmitReport (rid, reid) { return Report.getSubmitReport(rid, reid).then(res => res) }
  /* 更新学术报告 */
  updateSubmitReport (rid, reid, obj) { return Report.updateSubmitReport(rid, reid, obj).then(res => res) }
  /* 删除学术报告 */
  deleteSubmitReport (rid, reid) { return Report.deleteSubmitReport(rid, reid).then(res => res) }
  /* 获取事务类型 */
  getAffairsType () { return Report.getAffairsType().then(res => res) }
  /* 获取事务列表内容 */
  getAffairsData (obj) { return Report.getAffairsData(obj).then(res => res) }
  /* 提交事务申请 */
  submitLearning (obj) { return Report.submitLearning(obj).then(res => res) }
  /* 删除事务 */
  deleteAffairs (reid) { return Report.deleteAffairs(reid).then(res => res) }
  /* 获取事务详情 */
  getAffairsDetails (rid) { return Report.getAffairsDetails(rid).then(res => res) }
  /* 修改事务 */
  updateAffairs (rid, obj) { return Report.updateAffairs(rid, obj).then(res => res) }
  /* 重修图片上传 */
  uploadFile (obj) { return Report.uploadFile(obj).then(res => res) }
}
