export default [
  { path: '*', redirect: '/' },
  { path: '/', redirect: '/app/learn/course' },
  /* 学习系统 - 登录后，进入页面 */
  {
    path: '/app',
    redirect: '/app/error/404',
    component: () => import('@/pages/mainsite.vue'),
    children: [
      {
        path: 'error/404',
        component: () => import('@/components/errorPages/404.vue')
      },
      {
        path: 'other',
        redirect: 'error/404',
        component: () => import('@/components/learnSysLayout/container.vue'),
        children: [
          {
            path: 'message',
            component: () => import('../pages/other/message.vue')
          },
          {
            path: 'set-pwd',
            component: () => import('../pages/other/setPwd.vue')
          },
          {
            path: 'update-pic',
            component: () => import('../pages/other/updatePic.vue')
          }
        ]
      },
      {
        path: 'learn',
        redirect: 'error/404',
        component: () => import('@/components/learnSysLayout/container.vue'),
        children: [
          {
            path: 'course',
            component: () => import('../pages/learn/course.vue')
          },
          {
            path: 'course-all',
            component: () => import('../pages/learn/courseAll.vue')
          },
          {
            path: 'course-detail/:sid/:cid',
            component: () => import('../pages/learn/courseDetail.vue'),
            props: true
          },
          {
            path: 'discuss-detail/:sid/:cid/:id',
            component: () => import('../pages/learn/discussDetail.vue'),
            props: true
          },
          {
            path: 'discussion',
            component: () => import('../pages/learn/discussion.vue')
          },
          {
            path: 'report-list',
            component: () => import('../pages/learn/reportList.vue')
          },
          {
            path: 'report-active-list',
            component: () => import('../pages/learn/reportActiveList.vue')
          },
          {
            path: 'report-list-all/:rid',
            component: () => import('../pages/learn/reportListAll.vue'),
            props: true
          },
          {
            path: 'report-add/:rid',
            component: () => import('../pages/learn/reportAdd.vue'),
            props: true
          },
          {
            path: 'report-submit/:rid/:reid',
            component: () => import('../pages/learn/reportSubmit.vue'),
            props: true
          }
        ]
      },
      {
        path: 'grade',
        redirect: 'error/404',
        component: () => import('@/components/learnSysLayout/container.vue'),
        children: [
          {
            path: 'credit',
            component: () => import('../pages/grade/credit.vue')
          },
          {
            path: 'rebuild',
            component: () => import('../pages/grade/rebuild.vue')
          }
        ]
      },
      {
        path: 'feedback',
        redirect: 'error/404',
        component: () => import('@/components/learnSysLayout/container.vue'),
        children: [
          // { path: 'set-pwd', component: () => import('../pages/account/setPwd.vue') },
          // { path: 'update-pic', component: () => import('../pages/account/updatePic.vue') },
          {
            path: 'feedback-list',
            component: () => import('../pages/feedback/feedbackList.vue')
          },
          {
            path: 'feedback-create',
            component: () => import('../pages/feedback/feedbackCreate.vue')
          }
        ]
      },
      {
        path: 'affairs-hall',
        redirect: 'error/404',
        component: () => import('@/components/learnSysLayout/container.vue'),
        children: [
          {
            path: 'hall',
            component: () => import('../pages/affairsHall/hall.vue')
          },
          {
            path: 'learning-add/:rid',
            component: () => import('../pages/affairsHall/learningAdd.vue'),
            props: true
          },
          {
            path: 'share-add/:rid',
            component: () => import('../pages/affairsHall/shareAdd.vue'),
            props: true
          },
          {
            path: 'again-add/:rid',
            component: () => import('../pages/affairsHall/againAdd.vue'),
            props: true
          },
          {
            path: 'my-apply',
            component: () => import('../pages/affairsHall/myApply.vue'),
            props: true
          },
          {
            path: 'upload-report/:rid/:reid',
            component: () => import('../pages/affairsHall/uploadReport.vue'),
            props: true
          },
          {
            path: 'view-report/:rid',
            component: () => import('../pages/affairsHall/viewReport.vue'),
            props: true
          },
          {
            name: 'ehallRetakeAdd',
            path: 'retake/add',
            component: () => import(/* webpackChunkName: "ehall" */ '../pages/affairsHall/retake/edit.vue'),
            props: { isAdd: true }
          },
          {
            name: 'ehallRetakeEdit',
            path: 'retake/edit/:id',
            component: () => import(/* webpackChunkName: "ehall" */ '../pages/affairsHall/retake/edit.vue'),
            props: { isEdit: true }
          },
          {
            name: 'ehallRetakeView',
            path: 'retake/view/:id',
            component: () => import(/* webpackChunkName: "ehall" */ '../pages/affairsHall/retake/edit.vue'),
            props: { isView: true }
          }
        ]
      }
    ]
  },
  /* mobile 移动端 */
  {
    path: '/mobile',
    redirect: '/mobile/0/0/error/404',
    component: () => import('@/pages/mobile/index.vue'),
    props: true,
    children: [
      {
        path: 'error/404',
        component: () => import('@/components/errorPages/404.vue')
      },
      {
        path: 'list',
        name: 'mobileIndex',
        component: () => import('@/pages/mobile/list.vue'),
        props: true
      },
      {
        path: 'help/student',
        name: 'studentHelp',
        component: () => import('@/pages/mobile/studentHelp.vue')
      },
      {
        path: 'help/teacher',
        name: 'teacherHelp',
        component: () => import('@/pages/mobile/teacherHelp.vue')
      }
    ]
  },
  {
    path: '/survey/:sid/:cid',
    name: 'survey',
    component: () => import('@/pages/survey/survey.vue'),
    props: true
  }
]
