import Vue from 'vue' // 引入vue框架
import VueRouter from 'vue-router' // 使用 vue-router
import createRouter from './router' // router定义
import VueI18n from 'vue-i18n' // 使用 国际化
import createI18n from './assets/languages' // 国际化定义

import App from './app.vue' // 初始化 vue页面
import UploadForm from './components/upload-form'
import './style.scss' // 公共样式
import MetaInfo from 'vue-meta-info'
import Element from 'element-ui'
import modules from './modules'

import createBefore from './components/beforeEnter'
import store from './store'

import _ from 'lodash'
Vue.prototype.$_ = _

const VueRouterPush = VueRouter.prototype.push
VueRouter.prototype.push = function push (to) {
  return VueRouterPush.call(this, to).catch(err => err)
}

Vue.use(VueRouter)
Vue.use(UploadForm)
Vue.component(UploadForm.name, UploadForm)
const router = createRouter()
Vue.use(VueI18n)
const i18n = createI18n()

Vue.use(MetaInfo)

Vue.use(Element, { i18n: (key, value) => i18n.t(key, value) })
Vue.use(modules, { i18n })

/* 设置全局变量 */
window.G = Vue.prototype.$GLOBAL = {
  VERSION: 'PC-1.0.0'
}
// window.Promise = Promise
/**
 * 定义全局变量 - 用作全局事件发布订阅
 * 使用 vue自带事件 $emit 和 $on 进行发布订阅
 */
Vue.prototype.VueEvent = new Vue()
/* 创建实例之前，通过导航守卫，处理部分逻辑，如：是否直接进入系统 */
const before = createBefore()
/* 导航守卫 */
router.beforeEach((to, from, next) => {
  before.update(to, from, next)
})

window.G.$instance_vue = new Vue({
  router,
  i18n,
  store,
  render: h => h(App)
}).$mount('#app')
