import OtherAction from './OtherAction'
import CourseAction from './CourseAction'
import GradeAction from './GradeAction'
import ReportAction from './ReportAction'
import PlayerAction from './PlayerAction'
import DiscussAction from './DiscussAction'
import FeedbackAction from './FeedbackAction'

const Other = new OtherAction()
const Course = new CourseAction()
const Grade = new GradeAction()
const Report = new ReportAction()
const Player = new PlayerAction()
const Discuss = new DiscussAction()
const Feedback = new FeedbackAction()

const cAction = {
  Other,
  Course,
  Grade,
  Report,
  Player,
  Discuss,
  Feedback
}

/**
 * 统一处理接口返回请求
 * 由于使用 axios ，返回 then + finally 可能存在 部分浏览器不支持情况
 * 需要 添加兼容
 * @param {[object]} obj 整个对象
 * @param {[object]} obj.component 当前调用组件对象 传过来，必传
 * @param {[string]} obj.actionName action名字，必传
 * @param {[string]} obj.functionName action类中的方法名，必传
 * @param {[object]} obj.data 传输数据，必传
 * @param {[function]} obj.thenCallback 异步成功返回回调值，必传
 * @param {[function]} obj.catchCallback 异常抛出时，返回错误抓取回调值，必传
 * @param {[function]} obj.finallyCallback 最终finally回调，必传
 */
export const request = (obj) => {
  console.log(obj, '===========')
  cAction[obj.actionName][obj.functionName](obj.data).then(res => {
    obj.thenCallback(res)
  }).catch(e => {
    obj.component.$message.error(e.message)
    obj.catchCallback(e)
  }).finally(e => {
    obj.finallyCallback(e)
  })
}

export default cAction
