const isDev = process.env.NODE_ENV
const RegStrs = require('./regExpStr.js')

let config = {
  isDev: isDev,
  ResDir: 'src',
  DesDir: './client-dist',

  HtmlPath: 'src/index.html',
  IcoPath: 'src/assets/favicon.ico',

  JsPath: 'src/main.js',

  isHttps: true,

  isEnableToIphoneDebugger: false,

  CDN_BASE: 'https://zws-imgs-pub.ezijing.com/',
  CDN_DIR: 'static/build/learn-bluestar/',
  isUploadStatic: false,

  webpack: {}
}

config.RegStrs = RegStrs

let vueClientConfig = {}
config.domain = ''
if (config.isDev === 'development') {
  config.url = 'http://' + config.domain + ':12002'
  try {
    vueClientConfig = require('../.config.dev.js')
  } catch (error) {
    vueClientConfig = {}
    console.error('没有开发环境配置文件 -- `.config.dev.js`，正在使用默认配置')
  }
} else if (config.isDev === 'test') {
  config.url = '//api.ezijing.com'
  try {
    vueClientConfig = require('../.config.test.js')
  } catch (error) {
    vueClientConfig = {}
    console.error('没有测试环境配置文件 -- `.config.test.js`，正在使用默认配置')
  }
} else {
  config.url = '//api.ezijing.com'
  try {
    vueClientConfig = require('../.config.pro.js')
  } catch (error) {
    vueClientConfig = {}
    console.error('没有生产环境配置文件 -- `.config.pro.js`，正在使用默认配置')
  }
}

for (let k in vueClientConfig) {
  config[k] = vueClientConfig[k]
}

module.exports = config
