import { reportApi } from '@services'

export default class ReportAction {
  /* 获取学术报告列表 */
  getReportList () { return reportApi.getReportList().then(res => res) }
  /* 获取学术活动列表 */
  getReportActiveList () { return reportApi.getReportActiveList().then(res => res) }
  /* 提交活动申请 */
  submitReportActive (obj) { return reportApi.submitReportActive(obj).then(res => res) }
  /* 获取活动详情 */
  getReportActive (rid) { return reportApi.getReportActive(rid).then(res => res) }
  /* 修改活动申请 */
  updateReportActive (rid, obj) { return reportApi.updateReportActive(rid, obj).then(res => res) }
  /* 删除活动申请 */
  deleteReportActive (rid) { return reportApi.deleteReportActive(rid).then(res => res) }
  /* 获取活动相关的学术报告 */
  getReportListAll (obj) { return reportApi.getReportListAll(obj.rid).then(res => res) }
  /* 提交学术报告 */
  submitReport (rid, obj) { return reportApi.submitReport(rid, obj).then(res => res) }
  /* 获取报告详情 */
  getSubmitReport (rid, reid) { return reportApi.getSubmitReport(rid, reid).then(res => res) }
  /* 更新学术报告 */
  updateSubmitReport (rid, reid, obj) { return reportApi.updateSubmitReport(rid, reid, obj).then(res => res) }
  /* 删除学术报告 */
  deleteSubmitReport (rid, reid) { return reportApi.deleteSubmitReport(rid, reid).then(res => res) }
  getDataList () { return reportApi.getDataList().then(res => res) }
}
