export default class ConvertTime {
  /**
   * 工具方法 - 播放时间 转化 h:m:s
   * @param {[string]} duration 时间戳
   */
  durationToTimeString(duration) {
    const h = Math.floor(duration / 3600)
    const m = Math.floor((duration - h * 3600) / 60)
    const s = (duration - h * 3600 - m * 60) % 60
    function tenify(a) {
      return a >= 10 ? a : '0' + a
    }
    const to = { h: tenify(h), m: tenify(m), s: tenify(s) }
    const format = 'h:m:s'
    return format.replace(/h|m|s/g, k => to[k]).replace(/^00:/, '')
  }

  durationToTimeString2(duration) {
    const h = Math.floor(duration / 3600)
    const m = Math.floor((duration - h * 3600) / 60)
    const s = (duration - h * 3600 - m * 60) % 60
    let output = ''
    if (h) {
      output += `${h}小时`
    }
    if (m) {
      output += `${m}分钟`
    }
    if (s) {
      output += `${s}秒`
    }
    return output
  }
}
