const isDev = process.env.NODE_ENV === 'development'

let config = {
  ResName: 'client',
  DesName: '../server/client-dist',
  HtmlPath: 'client/project/index.html',
  JsPath: 'client/project/main.js',
  IcoPath: 'client/project/assets/favicon.ico',

  CDN_BASE: 'https://zws-imgs-pub.ezijing.com/',
  CDN_PATH: 'static/build/learn-enterprise/',

  isUploadStatic: false
}

if (isDev) {
  config.demain = 'dev.ezijing.com'
  config.url = 'http://dev.ezijing.com:4005'
} else {
  config.url = '//api.ezijing.com'
}

module.exports = config
