import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 获取课程详情
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 */
export function getCourse(semesterId, courseId) {
  return httpRequest.get(`/v2/education/courses/${semesterId}/${courseId}`)
}

/**
 * 获取章节资源详情
 * @param {string} vid 资源ID
 */
export function getChapterVideo(vid) {
  return httpRequest.post(
    '/v2/education/video-streaming',
    { vid },
    { headers: { 'Content-Type': 'application/json' } }
  )
}

/**
 * 获取章节资源详情
 * @param {string} vid 章节的资源ID
 */
export function getChapterVideoAliyun(vid) {
  return httpRequest.post(
    '/v2/education/aliyun-video-streaming',
    { vid },
    { headers: { 'Content-Type': 'application/json' } }
  )
}

/**
 * 获取答题信息
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 * @param {string} resourseId 章节的资源ID
 */
export function getChapterExam(semesterId, courseId, resourseId) {
  return httpRequest.get(
    `/v2/education/homeworks/${semesterId}/${courseId}/${resourseId}`
  )
}

/**
 * 提交考试
 */
export function sbumitChapterExam(params) {
  return httpRequest.post('/v2/education/homeworks', params, {
    headers: { 'Content-Type': 'application/json' }
  })
}

/**
 * 上传文件
 */
export function uploadFile(data) {
  return httpRequest.post('/util/upload-file', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/**
 * 获取课程大作业详情
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 */
export function getCourseWork(semesterId, courseId) {
  return httpRequest.get(
    `/v2/education/courses/${semesterId}/${courseId}/essay`
  )
}

/**
 * 提交课程大作业
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 */
export function updateCourseWork(semesterId, courseId, data) {
  return httpRequest.post(
    `/v2/education/courses/${semesterId}/${courseId}/essay`,
    data,
    { headers: { 'Content-Type': 'multipart/form-data' } }
  )
}

/**
 * 获取课程考试试题
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 */
export function getCourseExam(semesterId, courseId) {
  return httpRequest.get(`/v2/education/${semesterId}/${courseId}/examination`)
}

/**
 * 获取课程考试状态
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 * @param {string} examId 试题ID
 */
export function getCourseExamStatus(semesterId, courseId, examId) {
  return httpRequest.get(
    `/v2/education/${semesterId}/${courseId}/examination/${examId}/status`
  )
}

/**
 * 提交课程考试
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 * @param {string} examId 试题ID
 */
export function submitCourseExam(semesterId, courseId, examId, data) {
  return httpRequest.post(
    `/v2/education/${semesterId}/${courseId}/examination/${examId}/sheet`,
    data,
    { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } }
  )
}

/**
 * 获取课程考试结果
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 * @param {string} examId 试题ID
 */
export function getCourseExamResult(semesterId, courseId, examId) {
  return httpRequest.get(
    `/v2/education/${semesterId}/${courseId}/examination/${examId}/sheet`
  )
}
