import { courseApi } from '@services'
import tools from '@tools'

/**
 * 小程序 跟 PC 区别
 * 1. PC 直接使用 then，小程序 需要 callback
 * 2. PC 直接返回 对象，小程序 外层再保证一次返回 { status: xxx, data: data }
 */

export default class CourseAction {
  /* 获取学期分类信息 */
  getlearnFindList () {
    return courseApi.getlearnFindList().then(data => {
      let json = [{ val: '-1', name: '全部' }]
      for (let i = 0; i < data.length; i++) {
        let _list = data
        json.push({
          val: _list[i].id,
          name: _list[i].semester_name
        })
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取所有课程列表 - 选课广场 和 我的课程 共用同一个,通过 isMy判断 */
  getCourseList (isMy, param) {
    /**
     * 区别：
     * 1. progress 是 number
     */
    return courseApi.getCourseList(isMy, param).then(data => {
      let json = []
      for (let i = 0; i < data.length; i++) {
        let cur = data[i]
        let _cur = data[i].curriculum
        /* 课程类型 */
        let _type = cur.course_type
        let str1 = _type === 1 ? '必修课' : (_type === 2 ? '选修课' : (_type === 3 ? '重修课' : ''))
        json.push({
          id: cur.course_id,
          sid: cur.semester_id,
          src: (_cur && _cur.curriculum_picture) || '',
          title: cur.course_name,
          arrTab: [(((_cur && _cur.curriculum_credit) || 0) + '学分'), str1, cur.semester_name],
          status: _cur.is_enabled ? '已发布' : '未发布',
          time: cur.begin_date.split(' ')[0] + ' 至 ' + cur.end_date.split(' ')[0],
          myStatus: cur.selected !== 0 ? (cur.score ? ('总成绩：' + cur.score) : '已选修') : '未选修',
          progress: cur.video_progress
        })
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取某个课程详细信息 - 课程考核 和 课程讨论单独获取 */
  getCourseDetail (cid, sid) {
    return courseApi.getCourseDetail(cid, sid).then(data => {
      let cur = data
      let _cur = cur.curriculum
      /* 课程类型 */
      let _type = cur.course_type
      let str1 = _type === 1 ? '必修课' : (_type === 2 ? '选修课' : (_type === 3 ? '重修课' : ''))
      let json = {
        headerInfo: {
          isStart: !!cur.selected, // 是否为开始学习按钮 或者 选课按钮
          id: cur.course_id,
          sid: cur.semester_id,
          bgSrc: (_cur && _cur.curriculum_picture) || '../icons/home/default.jpg',
          title: cur.course_name,
          arrTab: [(((_cur && _cur.curriculum_credit) || 0) + '学分'), str1, cur.semester_name],
          status: _cur.is_enabled ? '已发布' : '未发布',
          time: cur.begin_date.split(' ')[0] + ' 至 ' + cur.end_date.split(' ')[0],
          progress: cur.video_progress,
          survey: cur.survey // 判别教学评估，是否已经填写
        },
        tabs0Content: {},
        tabs1ChapterList: {}
      }
      /* 课程简介 */
      json.tabs0Content = {
        text: _cur && _cur.curriculum_represent,
        teachers: []
      }
      for (let i = 0; i < cur.lecturers.length; i++) {
        let item = cur.lecturers[i]
        json.tabs0Content.teachers.push({
          src: item.lecturer_avatar,
          name: item.lecturer_name,
          edu: item.lecturer_education || '',
          job: item.lecturer_office || '',
          unit: item.lecturer_title || ''
        })
      }
      /* 课程内容 */
      json.tabs1ChapterList = {
        currentChapterId: cur.latest_play || '',
        currentVideoProvider: cur.latest_play_type || '1',
        course: cur.chapters.map((_, i) => {
          return {
            title: _.name,
            isUp: true,
            chapters: _.children.map((__, j) => {
              let _homework = (__.type === 3 && __.homework && __.homework.work_type === 1 && __.homework) || ''
              if (_homework) {
                _homework.course_id = data.course_id
                _homework.chapter_id = __.id
                _homework.work_id = __.resource_id
                _homework.semester_id = data.semester_id
              }
              if (__.live && __.live.id) {
                let str = ''
                switch (__.live.live_status) {
                  case 0: str = '直播未开始'; break
                  case 1: str = '正在直播'; break
                  case 2: str = '直播结束'; break
                  case 101: str = '直播结束，视频剪辑中'; break // 录制开始
                  case 102: str = '直播结束，视频剪辑中'; break // 录制结束
                  case 103: str = '观看回放'; break
                  default: str = '直播未开始'
                }
                // 5分钟内显示“即将开始”，5~1小时内“N分钟后开始”，1~24小时内“N小时后开始”，1天以上“N天后开始”天就显示年月日
                if (__.live.live_status === 0 && __.live.start_time) {
                  let time = (new Date(__.live.start_time).getTime() - new Date().getTime()) / 1000
                  if (time <= 5 * 60) {
                    str = '即将开始'
                  } else if (time <= 1 * 60 * 60) {
                    str = parseInt(time / 60) + '分钟后开始'
                  } else if (time <= 24 * 60 * 60) {
                    str = parseInt(time / (60 * 60)) + '小时' + parseInt(time / 60 % 60) + '分钟后开始'
                  } else {
                    str = parseInt(time / (24 * 60 * 60)) + '天后开始'
                  }
                }
                if (__.live.live_status === 103 && __.live.enable_record !== undefined && __.live.enable_record !== null && !__.live.enable_record) {
                  str = ''
                }
                __.live.statusStr = str
              }

              return {
                cid: cur.course_id,
                sid: cur.semester_id,
                vid: __.resource_id,
                id: __.id,
                video_provider: (__.video && __.video.video_provider) || '',
                duration: (__.video && __.video.video_length) || 0,
                time: (__.video && tools.convertTime.durationToTimeString(__.video.video_length)) || '',
                name: __.name,
                type: __.type,
                work_type: (__.homework && __.homework.work_type) || '',
                homework: _homework,
                live: __.live || ''
              }
            })
          }
        })
      }
      json.tabs1ChapterList.course.push({
        title: '课程大作业',
        isUp: true,
        chapters: [],
        type: 'course_work',
        sid: sid,
        cid: cid
      })
      json.tabs1ChapterList.course.push({
        title: '课程资料',
        isUp: true,
        chapters: [],
        type: 'course_info',
        sid: sid,
        cid: cid
      })
      json.tabs1ChapterList.course.push({
        title: '教学评估',
        isUp: true,
        chapters: [],
        type: 'teach_evaluation',
        sid: sid,
        cid: cid
      })
      if (cur.course_examination) {
        json.tabs1ChapterList.course.push({
          title: '课程考试',
          isUp: true,
          chapters: [],
          type: 'exam',
          sid: sid,
          cid: cid,
          examId: cur.course_examination
        })
      }
      /* 课程考核 考核标准文案读取  */
      json.tabs3richTest = cur.course_evaluation
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取课程考核信息 */
  getCourseAssess (cid, sid) {
    return courseApi.getCourseAssess(cid, sid).then(data => {
      let cur = data
      let video = []
      for (let i in cur.video_evaluation) {
        let _ = cur.video_evaluation[i]
        let tempArr = []
        for (let j in _.sections) {
          let __ = _.sections[j]
          tempArr.push({
            name: __.title,
            time: (__.duration && tools.convertTime.durationToTimeString(__.duration)) || '00:00',
            progress: (__.progress && (__.progress + '%')) || '0%',
            id: __.id
          })
        }
        video.push({
          title: _.title,
          arr: tempArr,
          sid: sid,
          cid: cid
        })
      }
      let homewrok = []
      for (let i in cur.homework_evaluation) {
        let _ = cur.homework_evaluation[i]
        let tempArr = []
        for (let j in _.sections) {
          let __ = _.sections[j]
          tempArr.push({
            name: __.title,
            created_time: __.created_time || '',
            score: __.score === null ? '暂无' : __.score
          })
        }
        homewrok.push({
          title: _.title,
          arr: tempArr
        })
      }
      let json = {
        score: cur.course_score,
        duration: tools.convertTime.durationToTimeString(cur.course_duration || 0),
        progress: cur.course_progress,
        video: video,
        homewrok: homewrok,
        essay: {
          created_time: cur.essay_evaluation.created_time || '',
          status: cur.essay_evaluation.status || '暂无',
          score: cur.essay_evaluation.score || '暂无'
        }
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 选课 */
  selectCourse (cid, sid) {
    return courseApi.selectCourse(cid, sid).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return res
    })
  }
  /* 退课 */
  outSelectCourse (cid, sid) {
    return courseApi.outSelectCourse(cid, sid).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return res
    })
  }
}
