import { chapterApi } from '@services'
import tools from '@tools'

export default class ChapterActon {
  /* 获取章节列表信息 */
  getChapterList (cid, sid, _id) {
    return chapterApi.getChapterList(cid, sid, _id).then(_res => {
      let i = 0
      let j = 0
      let nextVideo = {}
      let prevVideo = {}
      /* 计算上一章 和 下一章 */
      for (; i < _res.chapters.length; i++) {
        let _ = _res.chapters[i]
        for (j = 0; j < _.children.length; j++) {
          if (_.children[j].resource_id === _id) {
            // wx.setNavigationBarTitle({ title: _.children[j].name || '音视频' });
            if (j - 1 >= 0) {
              prevVideo = {
                id: _.children[j - 1].resource_id,
                time: (_.children[j - 1].video && tools.convertTime.durationToTimeString(_.children[j - 1].video.video_length)) || '',
                name: _.children[j - 1].name
              }
            } else if (i - 1 >= 0) {
              let _temp = _res.chapters[i - 1]
              prevVideo = {
                id: _temp.children[_temp.children.length - 1].resource_id,
                time: (_temp.children[_temp.children.length - 1].video && tools.convertTime.durationToTimeString(_temp.children[_temp.children.length - 1].video.video_length)) || '',
                name: _temp.children[_temp.children.length - 1].name
              }
            }
            if (j + 1 < _.children.length) {
              nextVideo = {
                id: _.children[j + 1].resource_id,
                time: (_.children[j + 1].video && tools.convertTime.durationToTimeString(_.children[j + 1].video.video_length)) || '',
                name: _.children[j + 1].name
              }
            } else if (i + 1 < _res.chapters.length) {
              let _temp = _res.chapters[i + 1]
              nextVideo = {
                id: _temp.children[0].resource_id,
                time: (_temp.children[0].video && tools.convertTime.durationToTimeString(_temp.children[0].video.video_length)) || '',
                name: _temp.children[0].name
              }
            }
          }
        }
      }
      let curJson = {}
      let json = {
        title: _res.course_name,
        sid: _res.semester_id,
        cid: _res.course_id,
        currentChapterId: _id,
        survey: _res.survey, // 判别教学评估，是否已经填写
        course: _res.chapters.map((_, i) => {
          return {
            title: _.name,
            chapters: _.children.map((__, j) => {
              let _homework = (__.type === 3 && __.homework && __.homework.work_type === 1 && __.homework) || ''
              if (_homework) {
                _homework.course_id = _res.course_id
                _homework.chapter_id = __.id
                _homework.work_id = __.resource_id
                _homework.semester_id = _res.semester_id
              }
              let _chapterWork = (__.type === 3 && __.homework && __.homework.work_type === 2 && __.homework) || ''
              let _chapterRead = (__.type === 4 && __.reading) || ''
              let _chapterVideo = (__.type === 2 && __.video) || ''
              if (_chapterVideo) {
                _chapterVideo.pdf = __.pdf || ''
              }
              if (_id === __.resource_id) {
                curJson = {
                  id: __.resource_id,
                  video_provider: (__.video && __.video.video_provider) || '',
                  time: (__.video && tools.convertTime.durationToTimeString(__.video.video_length)) || '',
                  name: __.name,
                  chapterId: __.id, // 需要chapterId 用来 提交 作业或问题 , 这个 chapterId 是 每个章节下 对应课程的 id，不是 章节id
                  type: __.type,
                  work_type: (__.homework && __.homework.work_type) || '',
                  homework: _homework,
                  chapterRead: _chapterRead,
                  chapterWork: _chapterWork,
                  chapterVideo: _chapterVideo
                }
              }
              return {
                id: __.resource_id,
                video_provider: (__.video && __.video.video_provider) || '',
                time: (__.video && tools.convertTime.durationToTimeString(__.video.video_length)) || '',
                name: __.name,
                type: __.type,
                work_type: (__.homework && __.homework.work_type) || '',
                homework: _homework,
                chapterRead: _chapterRead,
                chapterWork: _chapterWork,
                chapterVideo: _chapterVideo
              }
            })
          }
        }),
        nextVideo: nextVideo,
        prevVideo: prevVideo
      }
      json.course.push({
        title: '大作业及资料',
        chapters: [{
        //   name: '课程大作业',
        //   id: 'course_work'
        // }, {
          name: '课程资料',
          id: 'course_info'
        }, {
          name: '教学评估',
          id: 'teach_evaluation'
        }]
      })
      let courseWork = _res.curriculum || {}
      courseWork['end_date'] = _res.end_date
      courseWork['essay_date'] = _res.essay_date
      // callback(json) // 可以不使用callback 因为使用then
      return {
        json: json,
        courseInfo: _res.files || [],
        courseWork: _res.curriculum || {},
        curJson: curJson
      }
    })
  }
  /* 获取对应某个章节的详细信息 */
  getCurrentChapterDetail (vid) {
    return chapterApi.getCurrentChapterDetail(vid).then(_res => {
      let json = {
        video: {
          src: _res.video[0].playurl,
          spareSrc: 'http://pd4t7ae3m.bkt.clouddn.com/test.mp4' // 正式环境时，需要将 contentVideo 中 spareSrc 改成 src
        },
        audio: {
          src: _res.audio[0].url,
          poster: (_res.ppts && _res.ppts[0] && _res.ppts[0].ppt_url) || ''
        },
        image: {
          imgUrls: (_res.ppts && _res.ppts.map(function (_, i) { return _.ppt_url })) || [],
          current: 0,
          selectIndex: 0,
          timeArr: (_res.ppts && _res.ppts.map(function (_, i) { return _.ppt_point })) || []
        },
        rData: _res
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取对应某个章节的详细信息 */
  getCurrentChapterDetailAliyun (vid) {
    return chapterApi.getCurrentChapterDetailAliyun(vid).then(_res => {
      let json = {
        video: {
          FD: _res.video.FD,
          LD: _res.video.LD,
          SD: _res.video.SD
        },
        audio: {
          src: _res.video.SQ,
          poster: (_res.ppts && _res.ppts[0] && _res.ppts[0].ppt_url) || ''
        },
        image: {
          imgUrls: (_res.ppts && _res.ppts.map(function (_, i) { return _.ppt_url })) || [],
          current: 0,
          selectIndex: 0,
          timeArr: (_res.ppts && _res.ppts.map(function (_, i) { return _.ppt_point })) || []
        },
        rData: _res
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取进度信息 */
  getProgress (vid, did, sid) {
    return chapterApi.getProgress(vid, did, sid).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return {
        id: res.id,
        cpt: parseInt(res.cpt),
        mpt: parseInt(res.mpt),
        pt: parseInt(res.pt),
        progress: res.progress,
        sign: res.sign,
        map: res.map || []
      }
    })
  }
  /* 提交进度信息 */
  updateProgress (obj) {
    return chapterApi.updateProgress(obj).then(res => res)
    // return new Promise((resolve, reject) => { resolve({ success: true }) }) // 测试 视频时，不上传 视频数据
  }
  /* 获取试题信息 */
  getExamDetail (sid, cid, eid) {
    return chapterApi.getExamDetail(sid, cid, eid).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return res
    })
  }
  /* 提交考试信息 */
  submitExamDetail (param) {
    return chapterApi.submitExamDetail(param).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return res
    })
  }
  /* 获取对应 作业或问题 回答 */
  getHomework (sid, cid, id) {
    return chapterApi.getHomework(sid, cid, id).then(res => res)
  }
  /**
   * 文件上传
   */
  uploadFile (obj) { return chapterApi.uploadFile(obj).then(res => res) }
  /* 提交作业 */
  updateHomework (obj) { return chapterApi.updateHomework(obj).then(res => res) }
  /* 获取大作业 回答 */
  getCourseHomework (sid, cid) { return chapterApi.getCourseHomework(sid, cid).then(res => res) }
  /* 提交大作业 */
  updateCourseHomework (sid, cid, obj) { return chapterApi.updateCourseHomework(sid, cid, obj).then(res => res) }
  /* 提交课程考核 */
  updateSurveyAnswer (obj) { return chapterApi.updateSurveyAnswer(obj).then(res => res) }
}
