import BaseAPI from '@/api/base_api'

export default class LoginAPI extends BaseAPI {
  /**
   * 调用登录接口
   * @param {[string]} obj.login_name 用户名
   * @param {[string]} obj.password 密码 md5加密
   * @param {[string]} obj.service 传当前域名
   */
  userLogin = (obj = {}) => this.post('/user_center/login', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 调用退出登录
   */
  outLogin = () => this.get('/user_center/logout', {}, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 当前登录用户，检测是否该系统有权限
   */
  getInfo = () => this.get('/user/getinfo', {}, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 发送验证码
   * @param {[string]} obj.mobile 手机号
   * @param {[string]} obj.service 传当前域名
   */
  sendCode = (obj = {}) => this.post('/user_center/send_login_code', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 验证码登录
   * @param {[string]} obj.mobile 手机号
   * @param {[string]} obj.code 验证码
   * @param {[string]} obj.service 传当前域名
   */
  codeLogin = (obj = {}) => this.post('/user_center/code_login', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 发送重置密码验证码
   * @param {[string]} obj.contact 手机号/邮箱
   * @param {[string]} obj.source_type 值为 3
   * @param {[string]} obj.service 传当前域名
   */
  sendResetPwdCode = (obj = {}) => this.post('/user_center/send_reset_password_code', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 重置密码验证码确认
   * @param {[string]} obj.contact 手机号/邮箱
   * @param {[string]} obj.code 验证码
   * @param {[string]} obj.service 传当前域名
   */
  validateCode = (obj = {}) => this.post('/user_center/validate_code', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 重置密码
   * @param {[string]} obj.contact 手机号/邮箱
   * @param {[string]} obj.code 验证码
   * @param {[string]} obj.new_password 新的密码
   * @param {[string]} obj.service 传当前域名
   */
  resetPwd = (obj = {}) => this.post('/user_center/reset_password', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 个人信息 - 修改密码
   * @param {[string]} obj.old_password 验证码
   * @param {[string]} obj.new_password 新的密码
   * @param {[string]} obj.service 传当前域名
   */
  updatePwd = (obj = {}) => this.post('/user_center/change_password', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 清空所有cookies
   */
  clearCookies = (obj = {}) => this.post('https://learn-pbcsf.ezijing.com/api/clear/cookie', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
}
