import BaseAPI from './base_api'

export default class AffairsAPI extends BaseAPI {
  /**
   * 获取事务类型
   */
  getAffairsType = () => this.get('/v2/lobby/affairs')
  /**
   * 获取事务类型
   */
  getAffairsData = (obj = {}) => this.get('/v2/lobby/processes', obj)
  /**
   * 提交活动申请
   * affair_id 活动名称
   * symposium_name 活动时间
   * symposium_contents 活动讲师
   * symposium_attachments 活动内容
   * symposium_time 活动附件
   * symposium_address 活动地点
   * symposium_lecturer
   * 返回 {'flag' : true, 'errors' : []}
   */
  submitLearning = (obj = {}) => this.post('/v2/lobby/processes', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
  /* 删除事务 */
  deleteAffairs = (reid) => this.delete(`/v2/lobby/processes/${reid}`, {})
  /* 获取事务详情 */
  getAffairsDetails = (rid) => this.get(`/v2/lobby/processes/${rid}`, {})
  /* 修改事务 */
  updateAffairs = (rid, obj = {}) => this.post(`/v2/lobby/processes/${rid}`, obj, { headers: { 'Content-Type': 'multipart/form-data' } })
  /* 重修图片提交 */
  uploadFile = (obj = {}) => this.post('/v2/lobby/tools/upload', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
}
