module.exports = {
  /**
   * 工具方法 - 日期时间 转化 y-m-d
   * @param {[string]} duration 时间戳
   */
  durationToDateString: (duration) => {
    let y = new Date(duration).getFullYear()
    let m = new Date(duration).getMonth() + 1
    if (m < 10) {
      m = '0' + m
    } else {
      m = m + ''
    }
    let d = new Date(duration).getDate()
    if (d < 10) {
      d = '0' + d
    } else {
      d = d + ''
    }
    return y + '-' + m + '-' + d
  },
  /**
   * 工具方法 - 播放时间 转化 h:m:s
   * @param {[string]} duration 时间戳
   */
  durationToTimeString: (duration) => {
    let h = Math.floor(duration / 3600)
    let m = Math.floor((duration - h * 3600) / 60)
    let s = (duration - h * 3600 - m * 60) % 60
    function tenify (a) {
      return a >= 10 ? a : '0' + a
    }
    let to = { h: tenify(h), m: tenify(m), s: tenify(s) }
    let format = 'h:m:s'
    return format.replace(/h|m|s/g, k => to[k]).replace(/^00:/, '')
  }
}
