import BaseAPI from './base_api'

export default class GradeAPI extends BaseAPI {
  /**
   * 获取我的学分信息
   */
  getCredit = () => this.get('/api/lms-ep/v2/education/credits', {})
  /**
   * 提交 重修课程
   */
  submitRebuild = (obj = {}) =>
    this.post('/api/lms-ep/v2/education/retake', obj, { headers: { 'Content-Type': 'multipart/form-data' } })

  /**
   * 获取意见列表
   * type_id [int]
   * page [int]
   * pageSize [int]
   */
  feedbackList = (obj = {}) =>
    this.get('/api/lms-ep/v2/feedback/lists', obj, { headers: { 'Content-Type': 'multipart/form-data' } })

  /**
   * 意见反馈回复
   * feedback_id [int]
   * contents [string]
   */
  feedbackReply = (obj = {}) =>
    this.post('/api/lms-ep/v2/feedback/reply', obj, { headers: { 'Content-Type': 'multipart/form-data' } })

  /**
   * 意见反馈提交
   */
  feedbackCommit = (obj = {}) =>
    this.post('/api/lms-ep/v2/feedback/commit', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
}
