import BaseAPI from './base_api'
import _ from 'lodash'

export default class OtherAPI extends BaseAPI {
  /**
   * 当前登录用户，检测是否该系统有权限
   * /user_center/get_user_info
   */
  getInfo = () =>
    this.get('/api/lms-ep/user/check-access', {}, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })

  /**
   * 当前登录用户，检测是否该系统有权限
   * /user_center/get_user_info
   */
  getUser = () =>
    this.get(
      '/api/passport/account/get-user-info',
      {},
      { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } }
    )

  /**
   * 获取我的消息信息
   */
  getMyMsg = (obj = {}) => this.get('/api/lms-ep/v2/education/message/my', obj, {})

  /* 支持三方登录 */
  examAutoLogin = obj =>
    this.post('/api/lms-ep/util/kaosx', obj, {
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
    })

  /**
   * 标记已读未读
   */
  setMyMsg = rid => this.post(`/api/lms-ep/v2/education/message/${rid}`, {})

  getNavMsg = rid => this.get(`/api/lms-ep/v2/education/message/num?v=${new Date().getTime()}`, {})

  /**
   * wmp标记已读未读
   */
  setMsgWmp = rid => this.get(`/api/lms-ep/v2/education/message/read/${rid}`, {})

  /**
   * 调用退出登录
   */
  outLogin = () => this.get('/api/passport/rest/logout')

  /**
   * 文件提交
   * @param {[object]} obj
   */
  uploadFile = (obj = {}) =>
    this.post('/api/lms-ep/util/upload-file', obj, {
      headers: { 'Content-Type': 'multipart/form-data' }
    })

  /**
   * 个人信息 - 修改密码
   * @param {[string]} obj.old_password 验证码
   * @param {[string]} obj.new_password 新的密码
   * @param {[string]} obj.service 这里 一直是定值 h5.ezijing.com
   */
  updatePwd = (obj = {}) =>
    this.post('/api/usercenter/user/change-pwd-by-cookie', _.assignIn(obj, { service: 'h5.ezijing.com' }), {
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
    })

  /**
   * 个人信息 - 上传头像
   */
  updatePic = (obj = {}) =>
    this.post('/api/lms-ep/v3/storage/upload/avatar', obj, {
      headers: { 'Content-Type': 'multipart/form-data' }
    })

  /**
   * 发送验证码
   */
  sendCode = (obj = {}) =>
    this.post('/api/usercenter/user/send-code', obj, {
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
    })

  /**
   * 注册
   */
  register = (obj = {}) =>
    this.post('/api/lms-ep/user/register', obj, {
      headers: { 'Content-Type': 'multipart/form-data' }
    })

  updateUser = (obj = {}) =>
    this.post('/api/usercenter/user/update-user', obj, {
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
    })
}
