import { examApi } from '@services'

export default class ExamAction {
  /* 获取考卷信息 */
  getExamInfo (cid, sid) {
    return examApi.getExamInfo(cid, sid).then(_res => {
      let exam = {}
      exam.id = _res.id
      exam.title = _res.title
      exam.radioList = _res.examination.radioList
      for (let i = 0; i < exam.radioList.length; i++) {
        exam.radioList[i].user_answer = ''
        exam.radioList[i].right_answer = ''
        exam.radioList[i].get_score = -1
      }
      exam.checkboxList = _res.examination.checkboxList
      for (let i = 0; i < exam.checkboxList.length; i++) {
        exam.checkboxList[i].user_answer = []
        exam.checkboxList[i].right_answer = []
        exam.checkboxList[i].get_score = -1
      }
      exam.shortAnswerList = _res.examination.shortAnswerList
      for (let i = 0; i < exam.shortAnswerList.length; i++) {
        exam.shortAnswerList[i].user_answer = ''
        exam.shortAnswerList[i].get_score = -1
        exam.shortAnswerList[i].attachments = []
        exam.shortAnswerList[i].upload = {
          type: 'upload-form',
          label: '附件上传：',
          model: 'attachments',
          action: webConf.apiBaseURL + '/util/upload-file',
          data: {
            special: 'exam'
          },
          attrs: {
            multiple: true,
            headers: {
              'tenant': 'sofia'
            }
          },
          html: `
            <div style="color: #72818c; font-size: 14px;">
              <p style="margin: 0;">支持doc,docx,ppt,xls,txt,rar,zip,pdf,jpg,pic,png格式的文件，文件小于30M。</p>
            </div>
          `
        }
      }
      return exam
    })
  }
  /* 获取考卷结果 */
  getExamAnswer (cid, sid, eid) {
    return examApi.getExamAnswer(cid, sid, eid).then(_res => {
      let exam = {}
      exam.id = _res.id
      exam.title = _res.title
      exam.radioList = _res.sheet.radioList
      for (let i = 0; i < exam.radioList.length; i++) {
        let tmp = exam.radioList[i]
        if (!tmp.user_answer) tmp.user_answer = ''
        if (!tmp.right_answer) tmp.right_answer = ''
        if (!tmp.get_score) tmp.get_score = -1
      }
      exam.checkboxList = _res.sheet.checkboxList
      for (let i = 0; i < exam.checkboxList.length; i++) {
        let tmp = exam.checkboxList[i]
        if (!tmp.user_answer || !tmp.user_answer.length) tmp.user_answer = []
        if (!tmp.right_answer || !tmp.right_answer.length) tmp.right_answer = []
        if (!tmp.get_score) tmp.get_score = -1
      }
      exam.shortAnswerList = _res.sheet.shortAnswerList
      for (let i = 0; i < exam.shortAnswerList.length; i++) {
        let tmp = exam.shortAnswerList[i]
        if (!tmp.attachments || !tmp.attachments.length) tmp.attachments = []
        tmp.upload = {
          type: 'upload-form',
          label: '附件上传：',
          model: 'attachments',
          action: webConf.apiBaseURL + '/util/upload-file',
          data: {
            special: 'exam',
            headers: {
              'tenant': 'sofia'
            }
          },
          attrs: {
            multiple: true
          },
          html: `
            <div style="color: #72818c; font-size: 14px;">
              <p style="margin: 0;">支持doc,docx,ppt,xls,txt,rar,zip,pdf,jpg,pic,png格式的文件，文件小于30M。</p>
            </div>
          `
        }
      }
      return exam
    })
  }
  /* 提交考卷 */
  submitExam (cid, sid, eid, obj) {
    return examApi.submitExam(cid, sid, eid, obj).then(_res => {
      return _res
    })
  }
}
