/**
 * 测验类章节
 * chapter
 * courseId
 * action
 * dispatch
 */
import React from 'react'
import Formsy from 'formsy-react';
import FormsyComponent from '../../components/formsy/Component.jsx'
import FormItem from '../../components/formsy/FormItem.jsx'
import CoursesAction from '../../actions/CoursesAction'
import OperateAction from '../../actions/OperateAction'
import { getRequestTypes } from '../../libs/utils';

class ChapterExam extends FormsyComponent {
    constructor(props) {
        super(props);
        this.state = { error: '' };
    }
    componentDidMount () {
        this.courseAction = new CoursesAction();
        this.operateAction = new OperateAction();

        this.startTime = (new Date()).getTime();
        // 加载回答
        this.props.dispatch(this.courseAction.loadChapterWork(this.props.semesterId, this.props.chapter.homework.id));
    }
    componentWillReceiveProps (nextProps) {
        let submitType = getRequestTypes(CoursesAction.SUBMIT_CHAPTER_WORK);
        switch (nextProps.action.type) {
            case submitType.success:
                this.disableSubmitButton();
                // 提交成功，重新获取答案
                nextProps.dispatch(this.courseAction.loadChapterWork(this.props.semesterId, nextProps.chapter.homework.id));
                nextProps.handleSubmited(nextProps.chapter.id);
                break;
            case submitType.failure:
                this.enableSubmitButton();
                nextProps.dispatch(this.operateAction.showErrorMessage(nextProps.action.error.message || '提交章节测验失败'));
                break;
        }
    }

    /**
     * 提交登录
     */
    onSubmit = model => {
        this.loadingSubmitButton();

        const {courseId, chapter, semesterId} = this.props;
        const questions = chapter.homework && chapter.homework.questions || [];
        let data = {
            course_id: courseId,
            chapter_id:chapter.id,
            work_id: chapter.homework.id,
            semester_id: semesterId,
            work_contents: '',
            //url: '',
            duration: Math.ceil(((new Date()).getTime() - this.startTime) / 1000),
            score: 0
        }
        // 组织返回答案结构
        let correctNumber = 0;
        let answers = [];
        questions.forEach(q => {
            let opts = [],
                isCorrect = 0, seledNum = 0, correctCount = 0,
                curSels = q.question_type === 2 ? model[q.id] || [] : [model[q.id] || ''],
                options;
            try {
                options = JSON.parse(q.question_options);
            } catch (e) {
                options = [];
                console.log('Try parse question_options JSON string fail. in play/ChapterExam');
            }
            options.forEach(o => {
                let isSelected = (curSels.indexOf(o.id) >= 0) - 0;
                if (o.checked) { correctCount++; }
                if (o.checked && isSelected) { seledNum++; }
                opts.push({
                    id: o.id,
                    option: o.option,
                    checked: o.checked,
                    selected: isSelected
                });
            });
            isCorrect = (seledNum && seledNum === correctCount) - 0;

            answers.push({
                question_id: q.id,
                options: opts,
                is_correct: isCorrect
            });

            if (isCorrect) { correctNumber++; }
        });

        data.score = Math.round(correctNumber / questions.length * 1000) / 10; // 百分制
        data.work_contents = JSON.stringify(answers);

        this.props.dispatch(this.courseAction.submitChapterWork(data));
    }

    // 表单变更时，取消掉全局错误消息
    onFormChange = () => {
        this._setState({ error: '' });
    }

    // 将答案解析出来
    parseAnswers = (strAnswers) => {
        if (strAnswers === this._lastParseString && this._lastParseAnswers) {
            return this._lastParseAnswers;
        }
        let r = {};
        try {
            let answers = JSON.parse(strAnswers);
            this._lastParseString = strAnswers; // 记录上次成功解析的串
            (answers || []).forEach(q => {
                let opts = {};
                (q.options || []).forEach(o => {
                    opts[o.id] = o;
                });
                r[q.question_id] = opts;
            });
            this._lastParseAnswers = r; // 记录上次的解析结果
        } catch (e) { console.log('parse answer string to json failed.', e) }
        return r;
    }

    render () {
        const {chapter, chapter_work} = this.props;
        const questions = chapter.homework && chapter.homework.questions;
        let work = null;
        let answers = {}
        if (chapter_work.data && chapter_work.data.work_contents) {
            work = chapter_work.data;
            answers = this.parseAnswers(work.work_contents);
        }

        return (
            <div className="play-paper">
                <div className="play-paper-body">
                    <div className="play-paper-title"><div><h3>{chapter.name}</h3></div></div>
                    <div className="play-paper-content play-chapter-exam">
                        {work ?
                            <div className="result">正确率：{work.score || 0}%</div>
                            : null
                        }
                        <Formsy.Form
                            onValid={this.enableSubmitButton}
                            onInvalid={this.disableSubmitButton}
                            onValidSubmit={this.onSubmit}
                            onChange={this.onFormChange}
                        >
                            {questions.length ?
                                <ul>
                                    {questions.map((q, qi) => {
                                        let options;
                                        let formOpts = {};
                                        let rights = [];
                                        let isCheckbox = q.question_type === 2;
                                        let answer = answers[q.id] || {};
                                        try {
                                            options = JSON.parse(q.question_options);
                                            options.forEach((o, i) => {
                                                let k = String.fromCharCode(65 + i);
                                                formOpts[o.id] = k + '. ' + o.option;
                                                if (o.checked) rights.push(k);
                                            })
                                        } catch (e) {}
                                        return (
                                            <li key={qi}>
                                                <div className="exam-number">{qi + 1}.</div>
                                                <div className="exam-title"><div className="edit_html" dangerouslySetInnerHTML={{__html: (isCheckbox ? '(多选题)' : '(单选题)') + q.question_content}}></div></div>
                                                {!work ?
                                                    <FormItem
                                                        name={q.id}
                                                        itemType={isCheckbox ? FormItem.CHECKBOX : FormItem.RADIO}
                                                        options={formOpts}
                                                        required
                                                    />
                                                    :
                                                    <div>
                                                        {options.map((o, oi) => {
                                                            let selected = answer[o.id] && answer[o.id].selected;
                                                            let rclass = o.checked ? 'correct' : selected ? 'wrong' : '';
                                                            let tclass = isCheckbox ? 'checkbox' : 'radio';
                                                            return (
                                                                <div className={`${tclass} ${rclass}`} key={oi}>
                                                                    <label><input name={q.id} type={tclass} defaultChecked={selected} readOnly/>&nbsp;{String.fromCharCode(65 + oi)}. {o.option}</label>
                                                                </div>
                                                            );
                                                        })}
                                                        <div className="answer">正确答案：{rights.join(',')}</div>
                                                    </div>
                                                }
                                            </li>
                                        )
                                    })}
                                </ul>
                                :
                                <p className="no-data">暂无问题数据</p>
                            }

                            <p className="text-danger">{this.state.error}</p>
                            <div className="area-btns">
                                <button type="submit" disabled={!this.canSubmit() || work} className="btn btn-primary" >{this.isSubmitLoading() ? '保存中...' : work ? '已提交' : '提交'}</button>
                                <span className="help-info">&emsp;&emsp;注意：测试只有一次提交机会</span>
                            </div>
                        </Formsy.Form>
                    </div>
                </div>
            </div>
        );
    }
}

module.exports = ChapterExam;
