/**
 * 阅读类章节
 * chapter
 * handleReaded
 */
import React, { Component } from 'react'

class ChapterRead extends Component {
    componentDidMount() {
        const {chapter} = this.props;
        if (chapter && chapter.reading) {
            this.props.handleReaded();
        }
    }
    componentWillReceiveProps(nextProps) {
        if (this.props.chapter && nextProps.chapter &&
            this.props.chapter.id !== nextProps.chapter.id) {
            nextProps.handleReaded();
        }
    }

    render () {
        const {chapter} = this.props;
        const reads = chapter.reading ? [chapter.reading] : [];
        return (
            <div className="play-paper">
                <div className="play-paper-body">
                    <div className="play-paper-title"><div><h3>{chapter.name}</h3></div></div>
                    <div className="play-paper-content">
                        {reads.length ?
                            <ul className="play-read-files">
                                {reads.map((o,k) => {
                                    return <li key={k}><a href={o.reading_attachment} target="_blank">{o.reading_content}</a></li>
                                })}
                            </ul>
                            :
                            <p className="no-data">暂无阅读材料</p>
                        }
                    </div>
                </div>
            </div>
        );
    }
}

module.exports = ChapterRead;
