/**
 * 侧边显示讲义ppt
 * props:
 *      ppts: []
 *      handleClickPpt: func
 */
import React, { Component } from 'react'

class SidePpt extends Component {
    constructor (props) {
        super(props)
        this.state = { index: 0 }
    }

    // 根据播放时间同步展示ppt
    // @param time 播放时间
    setIndexByPoint = time => {
        const ppts = this.props.ppts || []
        const len = ppts.length
        let i = 0;
        for(; i < len; i++) {
            if (time < ppts[i].ppt_point) {
                break;
            }
        }
        if (this.state.index !== i - 1) {
            this.setState({ index: i - 1 });
        }
    }

    //handleSyncVideoTime = e => { // 点击ppt跳转对应的播放时间
    // 点击某个ppt
    onClickPpt = e => {
        let toIndex = e.currentTarget.getAttribute('data-index') - 0
        if (this.state.index === toIndex) { return }

        this.setState({ index: toIndex })
        this.props.handleClickPpt(toIndex)
    }

    render () {
        const {ppts} = this.props

        return (
            <div className="tab-pane current">
                <div className="jiangyi-list">
                    <div className="jy-list">
                        {(ppts || []).length ?
                            ppts.map((item, index) => {
                                return (
                                    <div key={index} onClick={this.onClickPpt} data-index={index} className={index === this.state.index ? 'current' : ''}>
                                        <img src={item.ppt_url} alt=""/>
                                    </div>
                                );
                            })
                            :
                            <div className="no-data">暂无讲义</div>
                        }
                    </div>
                </div>
            </div>
        );
    }
}

module.exports = SidePpt;
