import BaseAPI from '../base_api'

export default class ChapterAPI extends BaseAPI {
  /**
   * 获取章节列表信息
   * @param {[string]} cur_course_id -> cid
   * @param {[string]} cur_semester_id -> sid
   * @param {[string]} cur_video_id -> vid
   */
  getChapterList = (cid, sid, vid) => this.get(`/v2/education/courses/${sid}/${cid}`, {})
  /**
   * 获取对应某个章节的详细信息
   * @param {[string]} vid
   */
  getCurrentChapterDetail = (vid) => this.post('/v2/education/video-streaming', { vid })
  /**
   * 获取进度信息
   * @param {[string]} vid
   * @param {[string]} did
   * @param {[string]} sid
   */
  getProgress = (vid, did, sid) => this.get(`/v2/education/video/${sid}/${vid}/device`, { device_id: did })
  /**
   * 提交进度信息
   * @param {[object]} obj
   */
  updateProgress = (obj = {}) => this.post('/v2/analytics/upload-video', {
    d: obj.did,
    i: obj.did,
    c: obj.cid,
    s: obj.sid,
    v: obj.vid,
    _p: obj.pt, // 累计时间
    _m: obj.mpt, // 当前播放最大时间
    _c: obj.cpt // 当前播放位置
  })
}
