import BaseAPI from '../base_api'

export default class LoginAPI extends BaseAPI {
  /**
   * 调用登录接口
   * @param {[string]} obj.account 用户名
   * @param {[string]} obj.password 密码 md5加密
   */
  userLogin = obj => this.post('/tenant/user/login', obj)
  /**
   * 获取政策文件列表
   * @param {[string]} obj.page 传入页码
   * @param {[string]} obj.per_page 每页多少条
   */
  getDocuments = obj => this.get('/v1/cms/documents', obj)
  /**
   * 当前登录用户，检测是否该系统有权限
   */
  getInfo = () => this.get('/tenant/user/getinfo', {})
}
