export default class Cookies {
  /**
   * 设置 Cookies，用于客户端
   * @param {[string]} cName 要设置cookie的key值
   * @param {[string]} cValue 要设置cookie的value值
   * @param {[object]} obj 要设置cookie的其他值
   * @param {[object]} obj.path 路径
   * @param {[object]} obj.domain 域名
   * @param {[object]} obj.expires 过期时间
   */
  setCookie (cName, cValue, obj) {
    let d = new Date()
    if (obj.expires) {
      d.setTime(d.getTime() + ((obj.expires || 0) * 24 * 60 * 60 * 1000))
      obj.expires = d.toUTCString()
    }
    let str = ''
    for (let key in obj) {
      str += '; ' + key + '=' + obj[key]
    }
    document.cookie = cName + '=' + cValue + str
  }
  /**
   * 获取指定cookie，用于客户端
   * @param {[string]} cName 要获取cookie的key值
   */
  getCookie (cName) {
    let key = cName + '='
    let ca = document.cookie.split(';')
    for (let i = 0; i < ca.length; i++) {
      let c = ca[i]
      while (c.charAt(0) === ' ') c = c.substring(1)
      if (c.indexOf(key) !== -1) {
        return c.substring(key.length, c.length)
      }
    }
    return ''
  }
  /**
   * 获取全cookie，用于客户端
   */
  getAllCookies () {
    return document.cookie
  }
  /**
   * 清除cookie，用于客户端
   * @param {[string]} cName 要清除cookie的key值
   */
  clearCookie (cName) {
    document.cookie = cName + '=; expires=-1'
  }
}
