import { chapterApi } from '@services'
import tools from '@tools'

export default class ChapterActon {
  /* 获取章节列表信息 */
  getChapterList (cid, sid, vid, callback) {
    return chapterApi.getChapterList(cid, sid, vid).then(res => {
      let i = 0
      let j = 0
      let nextVideo = {}
      let prevVideo = {}
      /* 计算上一章 和 下一章 */
      for (; i < res.data.chapters.length; i++) {
        let _ = res.data.chapters[i]
        for (j = 0; j < _.children.length; j++) {
          if (_.children[j].resource_id === vid) {
            // wx.setNavigationBarTitle({ title: _.children[j].name || '音视频' });
            if (j - 1 >= 0) {
              prevVideo = {
                id: _.children[j - 1].resource_id,
                time: (_.children[j - 1].video && tools.convertTime.durationToTimeString(_.children[j - 1].video.video_length)) || '',
                name: _.children[j - 1].name
              }
            } else if (i - 1 >= 0) {
              let _temp = res.data.chapters[i - 1]
              prevVideo = {
                id: _temp.children[_temp.children.length - 1].resource_id,
                time: (_temp.children[_temp.children.length - 1].video && tools.convertTime.durationToTimeString(_temp.children[_temp.children.length - 1].video.video_length)) || '',
                name: _temp.children[_temp.children.length - 1].name
              }
            }
            if (j + 1 < _.children.length) {
              nextVideo = {
                id: _.children[j + 1].resource_id,
                time: (_.children[j + 1].video && tools.convertTime.durationToTimeString(_.children[j + 1].video.video_length)) || '',
                name: _.children[j + 1].name
              }
            } else if (i + 1 < res.data.chapters.length) {
              let _temp = res.data.chapters[i + 1]
              nextVideo = {
                id: _temp.children[0].resource_id,
                time: (_temp.children[0].video && tools.convertTime.durationToTimeString(_temp.children[0].video.video_length)) || '',
                name: _temp.children[0].name
              }
            }
          }
        }
      }
      let json = {
        isShow: false,
        currentChapterId: vid,
        course: res.data.chapters.map((_, i) => {
          return {
            title: _.name,
            chapters: _.children.map((__, j) => {
              let _homework = (__.type === 3 && __.homework && __.homework.work_type === 1 && __.homework) || ''
              if (_homework) {
                _homework.course_id = res.data.course_id
                _homework.chapter_id = __.id
                _homework.work_id = __.resource_id
                _homework.semester_id = res.data.semester_id
              }
              return {
                id: __.resource_id,
                time: (__.video && tools.convertTime.durationToTimeString(__.video.video_length)) || '',
                name: __.name,
                homework: _homework
              }
            })
          }
        }),
        nextVideo: nextVideo,
        prevVideo: prevVideo
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取对应某个章节的详细信息 */
  getCurrentChapterDetail (vid, callback) {
    return chapterApi.getCurrentChapterDetail(vid).then(res => {
      let json = {
        video: {
          src: res.data.video[0].playurl,
          spareSrc: 'http://pd4t7ae3m.bkt.clouddn.com/test.mp4' // 正式环境时，需要将 contentVideo 中 spareSrc 改成 src
        },
        audio: {
          src: res.data.audio[0].url,
          poster: (res.data.ppts && res.data.ppts[0] && res.data.ppts[0].ppt_url) || ''
        },
        image: {
          imgUrls: res.data.ppts && res.data.ppts.map(function (_, i) { return _.ppt_url }),
          current: 0,
          selectIndex: 0,
          timeArr: res.data.ppts && res.data.ppts.map(function (_, i) { return _.ppt_point })
        }
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取进度信息 */
  getProgress (vid, did, sid, callback) {
    return chapterApi.getProgress(vid, did, sid).then(res => {
      // callback(res.data) // 可以不使用callback 因为使用then
      return res.data
    })
  }
  /* 提交进度信息 */
  updateProgress (obj) {
    return chapterApi.updateProgress(obj).then(res => res)
  }
}
