import { courseApi } from '@services'
import tools from '@tools'

export default class CourseAction {
  /* 获取学期分类信息 */
  getlearnFindList (callback) {
    return courseApi.getlearnFindList().then(res => {
      let json = [{ val: '-1', name: '全部' }]
      for (let i = 0; i < res.data.length; i++) {
        let _list = res.data
        json.push({
          val: _list[i].id,
          name: _list[i].semester_name
        })
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取所有课程列表 - 选课广场 和 我的课程 共用同一个,通过 isMy判断 */
  getCourseList (isMy, param, callback) {
    return courseApi.getCourseList(isMy, param).then(res => {
      let json = []
      for (let i = 0; i < res.data.length; i++) {
        let cur = res.data[i]
        let _cur = res.data[i].curriculum
        /* 课程类型 */
        let _type = _cur.curriculum_elective_type
        let str1 = _type === 1 ? '必修课' : (_type === 2 ? '选修课' : (_type === 3 ? '重修课' : ''))
        json.push({
          id: cur.course_id,
          sid: cur.semester_id,
          src: (_cur && _cur.curriculum_picture) || '',
          title: cur.course_name,
          arrTab: [(((_cur && _cur.curriculum_credit) || 0) + '学分'), str1, cur.semester_name],
          status: _cur.is_enabled ? '已发布' : '未发布',
          time: cur.begin_date.split(' ')[0] + ' 至 ' + cur.end_date.split(' ')[0],
          myStatus: cur.selected !== 0 ? (cur.score ? ('总成绩：' + cur.score) : '已选修') : '未选修',
          progress: cur.course_progress + '%'
        })
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取某个课程详细信息 - 课程考核 和 课程讨论单独获取 */
  getCourseDetail (id, sid, callback) {
    return courseApi.getCourseDetail(id, sid).then(res => {
      let cur = res.data
      let _cur = cur.curriculum
      /* 课程类型 */
      let _type = _cur.curriculum_elective_type
      let str1 = _type === 1 ? '必修课' : (_type === 2 ? '选修课' : (_type === 3 ? '重修课' : ''))
      let json = {
        headerInfo: {
          isStart: !!cur.selected, // 是否为开始学习按钮 或者 选课按钮
          id: cur.course_id,
          sid: cur.semester_id,
          bgSrc: (_cur && _cur.curriculum_picture) || '../icons/home/default.jpg',
          title: cur.course_name,
          arrTab: [(((_cur && _cur.curriculum_credit) || 0) + '学分'), str1, cur.semester_name],
          status: _cur.is_enabled ? '已发布' : '未发布',
          time: cur.begin_date.split(' ')[0] + ' 至 ' + cur.end_date.split(' ')[0],
          progress: cur.course_progress + '%'
        },
        tabs0Content: {},
        tabs1ChapterList: {}
      }
      /* 课程简介 */
      json.tabs0Content = {
        text: _cur && _cur.curriculum_represent,
        teachers: []
      }
      for (let i = 0; i < cur.lecturers.length; i++) {
        let item = cur.lecturers[i]
        json.tabs0Content.teachers.push({
          src: item.lecturer_avatar,
          name: item.lecturer_name,
          edu: item.lecturer_education || '',
          job: item.lecturer_office || '',
          unit: item.lecturer_title || ''
        })
      }
      /* 课程内容 */
      json.tabs1ChapterList = {
        currentChapterId: cur.latest_play || '',
        course: cur.chapters.map((_, i) => {
          return {
            title: _.name,
            isUp: true,
            chapters: _.children.map((__, j) => {
              let _homework = (__.type === 3 && __.homework && __.homework.work_type === 1 && __.homework) || ''
              if (_homework) {
                _homework.course_id = res.data.course_id
                _homework.chapter_id = __.id
                _homework.work_id = __.resource_id
                _homework.semester_id = res.data.semester_id
              }
              return {
                cid: cur.course_id,
                sid: cur.semester_id,
                vid: __.resource_id,
                time: (__.video && tools.convertTime.durationToTimeString(__.video.video_length)) || '',
                name: __.name,
                homework: _homework
              }
            })
          }
        })
      }
      json.tabs1ChapterList.course.push({
        title: '课程大作业',
        isUp: true,
        chapters: []
      })
      json.tabs1ChapterList.course.push({
        title: '课程资料',
        isUp: true,
        chapters: []
      })
      /* 课程考核 考核标准文案读取  */
      json.tabs3richTest = cur.course_evaluation
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取课程考核信息 */
  getCourseAssess (cid, sid, callback) {
    return courseApi.getCourseAssess(cid, sid).then(res => {
      let cur = res.data
      let video = []
      for (let i in cur.video_evaluation) {
        let _ = cur.video_evaluation[i]
        let tempArr = []
        for (let j in _.sections) {
          let __ = _.sections[j]
          tempArr.push({
            name: __.title,
            time: (__.duration && tools.convertTime.durationToTimeString(__.duration)) || '00:00',
            progress: (__.progress && (__.progress + '%')) || '0%'
          })
        }
        video.push({
          title: _.title,
          arr: tempArr
        })
      }
      let homewrok = []
      for (let i in cur.homework_evaluation) {
        let _ = cur.homework_evaluation[i]
        let tempArr = []
        for (let j in _.sections) {
          let __ = _.sections[j]
          tempArr.push({
            name: __.title,
            score: __.score || '0'
          })
        }
        homewrok.push({
          title: _.title,
          arr: tempArr
        })
      }
      let json = {
        score: cur.course_score,
        duration: tools.convertTime.durationToTimeString(cur.course_duration || 0),
        progress: cur.course_progress,
        video: video,
        homewrok: homewrok,
        essay: {
          status: cur.essay_evaluation.status || '暂无',
          score: cur.essay_evaluation.score || '暂无'
        }
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取试题信息 */
  getExamDetail (eid, sid, callback) {
    return courseApi.getExamDetail(eid, sid).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return res
    })
  }
  /* 提交考试信息 */
  submitExamDetail (param, callback) {
    return courseApi.submitExamDetail(param).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return res
    })
  }
  /* 选课 */
  selectCourse (cid, sid, callback) {
    return courseApi.selectCourse(cid, sid).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return res
    })
  }
  /* 退课 */
  outSelectCourse (cid, sid, callback) {
    return courseApi.outSelectCourse(cid, sid).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return res
    })
  }
}
