import { scoreApi } from '@services'

export default class ScoreAction {
  /* 获取我的学分信息 */
  getMyScore (callback) {
    return scoreApi.getMyScore().then(res => {
      let _data = res.data
      let json = {
        total: _data.total_credits,
        myTotal: _data.my_total_credits,
        myTotalStr: (_data.total_credits && ((_data.my_total_credits * 1.0 / _data.total_credits * 100).toFixed(1) + '%')) || '0%',
        must: _data.required_credits,
        myMust: _data.my_required_credits,
        myMustStr: (_data.required_credits && ((_data.my_required_credits * 1.0 / _data.required_credits * 100).toFixed(1) + '%')) || '0%',
        unmust: _data.optional_credits,
        myUnmust: _data.my_optional_credits,
        myUnmustStr: (_data.optional_credits && ((_data.my_optional_credits * 1.0 / _data.optional_credits * 100).toFixed(1) + '%')) || '0%'
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
}
