import Vue from 'vue' // 引入vue框架
import Element from 'element-ui' // 引入 element-ui 框架
import './components/style/_com.scss' // 定义 element-ui主题色 + 公共样式
import VueRouter from 'vue-router' // 使用 vue-router
import createRouter from './router' // router定义
import Main from './main.vue' // 初始化 vue页面

/* 引入 md5 */
import md5 from 'js-md5'

/* 定义全局变量 */
import GlobalVariable from './components/beforeEnterPages/setGlobalVariable'
/* 处理低版本浏览器支持axiosfinally问题 */
// require('promise.prototype.finally').shim()
Vue.use(Element)
Vue.use(VueRouter)
const router = createRouter()
/* 设置全局变量 */
Vue.prototype.$GlobalVariable = {}
Vue.prototype.$md5 = md5
/* 导航守卫 */
router.beforeEach((to, from, next) => {
  /* 设置 全局变量 */
  new GlobalVariable(Vue, { to, from, next })
  next()
})
/**
 * 定义全局变量 - 用作全局事件发布订阅
 * 使用 vue自带事件 $emit 和 $on 进行发布订阅
 */
Vue.prototype.VueEvent = new Vue()

// /* 定义全局 jquery 变量 */
// Vue.prototype.jq = $

new Vue({
  router,
  render: (h) => h(Main)
}).$mount('#app')
