import App from '../app.vue'
import container from '../components/layout/container.vue'

export default [
  { path: '/', redirect: '/login' },
  {
    path: '/login',
    redirect: '/login/index',
    component: () => import('../../../components/login/login.vue'),
    children: [
      {
        path: 'index',
        name: 'normalLogin',
        component: () => import('../../../components/login/normal/normal.vue')
      },
      {
        path: 'code',
        name: 'codeLogin',
        component: () => import('../../../components/login/code/code.vue')
      },
      {
        path: 'forget',
        name: 'forgetPwd',
        component: () => import('../../../components/login/forget/forget.vue')
      }
    ]
  },
  /* App 内登录页面未找到时 - 指向 */
  { path: '/login/*', redirect: '/login/index' },
  {
    path: '/app',
    redirect: '/app/error/404',
    component: App,
    children: [
      { path: 'error/404', component: () => import('../components/error/404.vue') },
      {
        path: 'my-learn',
        redirect: 'error/404',
        component: container,
        children: [
          { path: 'course', component: () => import('../pages/myLearn/course.vue') },
          { path: 'course-detail', component: () => import('../pages/myLearn/courseDetail.vue') },
          { path: 'course-all', component: () => import('../pages/myLearn/courseAll.vue') },
          { path: 'discussion', component: () => import('../pages/myLearn/discussion.vue') },
          { path: 'report', component: () => import('../pages/myLearn/report.vue') }
        ]
      },
      {
        path: 'my-grade',
        redirect: 'error/404',
        component: container,
        children: [
          { path: 'credit', component: () => import('../pages/myGrade/credit.vue') }
        ]
      },
      {
        path: 'account',
        redirect: 'error/404',
        component: container,
        children: [
          { path: 'set-pwd', component: () => import('../pages/account/setPwd.vue') },
          { path: 'update-pic', component: () => import('../pages/account/updatePic.vue') }
        ]
      }
    ]
  },
  /* App 内未找到页面时 - 指向 */
  { path: '/app/*', redirect: '/app/error/404' },
  // {
  //   path: '/player',
  //   // redirect: '/login/index',
  //   component: () => import('../../../components/player/index.vue')
  //   // children: [
  //   //   {
  //   //     path: 'index',
  //   //     name: 'normalLogin',
  //   //     component: () => import('../../../components/login/normal/normal.vue')
  //   //   }
  //   // ]
  // },
  /* 如果所有页面都没找到 - 指向 */
  { path: '*', component: () => import('../components/error/404.vue') }
]
