import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

// 获取事务类型列表
export function getAffairType() {
  return httpRequest.get('/api/lms/v2/lobby/affairs')
}
// 获取事务列表
export function getAffairList(params) {
  return httpRequest.get('/api/lms/v2/lobby/processes', params).then(response => {
    const status = {
      '-1': '待审批',
      0: '未通过',
      1: '审批通过',
      2: '审批中'
    }
    if (response.list) {
      response.list = response.list.map(item => {
        item.status_name = status[item.status]
        return item
      })
    }
    return response
  })
}
// 获取事务详情
export function getAffair(id) {
  return httpRequest.get(`/api/lms/v2/lobby/processes/${id}`)
}
// 创建事务
export function createAffair(data) {
  return httpRequest.post('/api/lms/v2/lobby/processes', data)
}
// 更新事务
export function updateAffair(id, data) {
  return httpRequest.post(`/api/lms/v2/lobby/processes/${id}`, data)
}
// 删除事务
export function deleteAffair(id) {
  return httpRequest.delete(`/api/lms/v2/lobby/processes/${id}`)
}
// 上传文件
export function upload(data) {
  return httpRequest.post('/api/lms/v2/lobby/tools/upload', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}
// 获取学期
export function getSemesters() {
  return httpRequest.get('/api/lms/v2/lobby/semesters')
}
// 获取课程
export function getCourses(sid) {
  return httpRequest.get(`/api/lms/v2/lobby/semesters/${sid}/courses`)
}
// 获取成绩单
export function getReport(params) {
  return httpRequest.get('/api/lms/v2/lobby/havereport', params)
}
// 获取学生
export function getStudent() {
  return httpRequest.get('/api/lms/v2/lobby/student')
}
// 获取重修课程
export function getRetakeCourses() {
  return httpRequest.get('/api/lms/v2/lobby/courses')
}
// 更改事务状态
export function changeStatus(data) {
  return httpRequest.post('/api/lms/v2/lobby/changestatus', data)
}

// 创建微信支付订单
export function createWxpayOrder(identity, productId, params) {
  return httpRequest.get(`/api/pay/v1/wechat/qr/${identity}/${productId}`, params)
}

// 创建支付宝支付订单
export function createAlipayOrder(productId, params) {
  return httpRequest.get(`/api/pay/v1/ali/unified-order/${productId}`, params)
}

// 获取订单
export function getOrder(orderId) {
  return httpRequest.get(`/api/pay/v1/order/status/${orderId}`)
}

// 支付成功回调
export function paySuccess(id) {
  return httpRequest.get(`/api/lms/v2/lobby/update-status-api/${id}`)
}

// 获取学术活动报告列表
export function getAcitivityReportList(id) {
  return httpRequest.get(`/api/lms/v2/education/symposium/${id}/report`)
}

// 上传文件
export function uploadFile(data) {
  return httpRequest.post('/api/lms/v2/lobby/tools/upload', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}
