const util = require('../utils/util.js')
/**
 * 本API中全部用于 音视频 播放相关接口 
 */

/* 获取章节列表信息 */
// 测试 用 cur_course_id：6438232736871219200 cur_video_id：6290435412296990720
const getChapterList = (cur_course_id, cur_semester_id, cur_video_id, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/courses/' + cur_semester_id + '/' + cur_course_id,
    callback: function (res) {
      let i = 0, j = 0, nextVideo = {}, prevVideo = {};
      /* 计算上一章 和 下一章 */
      for (; i<res.data.chapters.length; i++) {
        let _ = res.data.chapters[i]
        for (j=0; j<_.children.length; j++) {
          if (_.children[j].resource_id === cur_video_id) {
            wx.setNavigationBarTitle({ title: _.children[j].name || '音视频' });
            if (j-1 >= 0) { 
              prevVideo = {  
                id: _.children[j-1].resource_id,
                time: _.children[j-1].video && util.durationToTimeString(_.children[j-1].video.video_length) || '',
                name: _.children[j-1].name
              }
            } else if (i-1>=0) {
              let _temp = res.data.chapters[i - 1]
              prevVideo = {
                id: _temp.children[_temp.children.length-1].resource_id,
                time: _temp.children[_temp.children.length-1].video && util.durationToTimeString(_temp.children[_temp.children.length-1].video.video_length) || '',
                name: _temp.children[_temp.children.length-1].name
              }
            } 
            if (j+1 < _.children.length) {
              nextVideo = {
                id: _.children[j + 1].resource_id,
                time: _.children[j + 1].video && util.durationToTimeString(_.children[j + 1].video.video_length) || '',
                name: _.children[j + 1].name
              }
            } else if (i + 1 < res.data.chapters.length) {
              let _temp = res.data.chapters[i + 1]
              nextVideo = {
                id: _temp.children[0].resource_id,
                time: _temp.children[0].video && util.durationToTimeString(_temp.children[0].video.video_length) || '',
                name: _temp.children[0].name
              }
            }
          }
        }
      }
      let json = {
        isShow: false, 
        currentChapterId: cur_video_id, 
        course: res.data.chapters.map(function (_, i) {
          return {
            title: _.name,
            chapters: _.children.map(function (__, j) {
              let _homework = __.type == 3 && __.homework && __.homework.work_type == 1 && __.homework || ''
              if (_homework) {
                _homework.course_id = res.data.course_id
                _homework.chapter_id = __.id
                _homework.work_id = __.resource_id
                _homework.semester_id = res.data.semester_id
              }
              return {
                id: __.resource_id,
                time: __.video && util.durationToTimeString(__.video.video_length) || '',
                name: __.name,
                homework: _homework
              }
            })
          }
        }),
        nextVideo: nextVideo,
        prevVideo: prevVideo
      }
      callback(json)
    }
  })
}
/* 获取对应某个章节的详细信息 */
const getCurrentChapterDetail = (vid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/video-streaming',
    method: 'POST',
    data: {
      vid: vid
    },
    callback: function (res) {
      let json = {
        video: {
          src: res.data.video[0].playurl,
          spareSrc: 'http://pd4t7ae3m.bkt.clouddn.com/test.mp4' // 正式环境时，需要将 contentVideo 中 spareSrc 改成 src
        },
        audio: {
          src: res.data.audio[0].url,
          poster: res.data.ppts && res.data.ppts[0] && res.data.ppts[0].ppt_url || ''
        },
        image: {
          imgUrls: res.data.ppts && res.data.ppts.map(function (_, i) { return _.ppt_url }), 
          current: 0, 
          selectIndex: 0,
          timeArr: res.data.ppts && res.data.ppts.map(function (_, i) { return _.ppt_point })
        }
      }
      callback(json)
    }
  }) 
}
/* 获取进度信息 */
// 测试 用 device_id : jjhz92fn0.le2a6c06c9g0.thhg7ekb1f8
const getProgress = (vid, did, sid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/video/' + sid + '/' + vid + '/device',
    data: {
      device_id: did
    },
    callback: function (res) {
      callback(res.data)
    }
  })
}
/* 提交进度信息 */
const updateProgress = (obj) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/analytics/upload-video',
    data: {
      d: obj.did,
      i: obj.did,
      c: obj.cid,
      s: obj.sid,
      v: obj.vid,
      _p: obj.pt,  // 累计时间
      _m: obj.mpt, // 当前播放最大时间
      _c: obj.cpt // 当前播放位置
    },
    callback: function (res) {}
  })
}
module.exports = {
  getChapterList: getChapterList,
  getCurrentChapterDetail: getCurrentChapterDetail,
  getProgress: getProgress,
  updateProgress: updateProgress
}