const util = require('../utils/util.js')
/**
 * 本API中全部用于 选课、我的课程、课程详情、讨论 相关接口 
 */

/* 获取学期分类信息 */
const getlearnFindList = (callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/semesters',
    callback: function (res) {
      let json = [{ val: '-1', name: '全部' }]
      for (let i = 0; i < res.data.length; i++) {
        let _list = res.data
        json.push({
          val: _list[i].id,
          name: _list[i].semester_name
        })
      }
      callback(json)
    }
  })
}
/* 获取所有课程列表 - 选课广场 和 我的课程 共用同一个,通过 isMy判断 */
const getCourseList = (isMy, param, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/courses' + (isMy ? '/my' : '' ),
    data: param, // json格式
    callback: function (res) {
      let json = [];
      for(let i = 0; i < res.data.length; i++) {
        let cur = res.data[i], _cur = res.data[i].curriculum
        /* 课程类型 curriculum_elective_type 类型 改为 course_type 吴锚要求 */
        let _type = cur.course_type, str1 = _type == 1 ? '必修课' : (_type == 2 ? '选修课' : (_type == 3 ? '重修课' : ''))
        
        json.push({
          id: cur.course_id,
          sid: cur.semester_id,
          src: _cur && _cur.curriculum_picture || '../icons/home/default.jpg',
          title: cur.course_name,
          arrTab: [((_cur && _cur.curriculum_credit || 0) + '学分'), str1, cur.semester_name],
          status: _cur.is_enabled ? '已发布' : '未发布',
          time: cur.begin_date.split(' ')[0] + ' 至 ' + cur.end_date.split(' ')[0],
          myStatus: cur.selected != 0 ? (cur.score ? ('总成绩：' + cur.score) : '已选修') : '未选修',
          progress: cur.video_progress + '%'
        })
      }
      callback(json)
    }
  })
}
/* 获取某个课程详细信息 - 课程考核 和 课程讨论单独获取 */
const getCourseDetail = (id, sid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/courses/' + sid + '/' + id,
    callback: function (res) {
      let cur = res.data, _cur = cur.curriculum
      /* 课程类型 curriculum_elective_type 类型 改为 course_type 吴锚要求 */
      let _type = cur.course_type, str1 = _type == 1 ? '必修课' : (_type == 2 ? '选修课' : (_type == 3 ? '重修课' : ''))
      let json = {
        headerInfo: {
          isStart: !!cur.selected, // 是否为开始学习按钮 或者 选课按钮
          id: cur.course_id,
          sid: cur.semester_id,
          bgSrc: _cur && _cur.curriculum_picture || '../icons/home/default.jpg',
          title: cur.course_name,
          arrTab: [((_cur && _cur.curriculum_credit || 0) + '学分'), str1, cur.semester_name],
          status: _cur.is_enabled ? '已发布' : '未发布',
          time: cur.begin_date.split(' ')[0] + ' 至 ' + cur.end_date.split(' ')[0],
          progress: cur.video_progress + '%'
        },
        tabs0Content: {},
        tabs1ChapterList: {}
      }
      /* 课程简介 */
      json.tabs0Content = {
        text: _cur && _cur.curriculum_represent,
        teachers: []
      }
      for (let i = 0; i < cur.lecturers.length; i++) {
        let item = cur.lecturers[i]
        json.tabs0Content.teachers.push({
          src: item.lecturer_avatar,
          name: item.lecturer_name,
          edu: item.lecturer_education || '',
          job: item.lecturer_office || '',
          unit: item.lecturer_title || ''
        })
      }
      /* 课程内容 */
      json.tabs1ChapterList = {
        currentChapterId: cur.latest_play || '',
        course: cur.chapters.map(function (_, i) {
          return {
            title: _.name,
            isUp: true,
            chapters: _.children.map(function (__, j) {
              let _homework = __.type == 3 && __.homework && __.homework.work_type == 1 && __.homework || ''
              if (_homework) {
                _homework.course_id = res.data.course_id
                _homework.chapter_id = __.id
                _homework.work_id = __.resource_id
                _homework.semester_id = res.data.semester_id
              }
              return {
                cid: cur.course_id,
                sid: cur.semester_id,
                vid: __.resource_id,
                time: __.video && util.durationToTimeString(__.video.video_length) || '',
                name: __.name,
                homework: _homework
              }
            })
          }
        })
      }
      json.tabs1ChapterList.course.push({
        title: '课程大作业',
        isUp: true,
        chapters: []
      })
      json.tabs1ChapterList.course.push({
        title: '课程资料',
        isUp: true,
        chapters: []
      })
      /* 课程考核 考核标准文案读取  */
      json.tabs3richTest = cur.course_evaluation
      callback(json)
    }
  })
}
/* 获取课程考核信息 */
const getCourseAssess = (cid, sid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/analytics/courses/' + sid + '/' + cid + '/evaluation',
    callback: function (res) {
      let cur = res.data
      let video = [];
      for (let i in cur.video_evaluation) {
        let _ = cur.video_evaluation[i]
        let tempArr = []
        for (let j in _.sections) {
          let __ = _.sections[j]
          tempArr.push({
            name: __.title,
            time: __.duration && util.durationToTimeString(__.duration) || '00:00',
            progress: __.progress && (__.progress + '%') || '0%'
          })
        }
        video.push({
          title: _.title,
          arr: tempArr
        })
      }
      let homewrok = [];
      for (let i in cur.homework_evaluation) {
        let _ = cur.homework_evaluation[i]
        let tempArr = []
        for (let j in _.sections) {
          let __ = _.sections[j]
          tempArr.push({
            name: __.title,
            created_time: __.created_time || '暂未提交',
            score: __.score || '0'
          })
        }
        homewrok.push({
          title: _.title,
          arr: tempArr
        })
      }
      let json = {
        score: cur.course_score,
        duration: util.durationToTimeString(cur.course_duration || 0),
        progress: cur.course_progress,
        video: video,
        homewrok: homewrok,
        essay: {
          created_time: cur.essay_evaluation.created_time || '',
          status: cur.essay_evaluation.status || '暂无',
          score: cur.essay_evaluation.score || '暂无'
        }
      }
      callback(json)
    }
  })
}
/* 获取试题信息 */
const getExamDetail = (eid, sid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/homeworks/' + sid + '/' + eid,
    callback: function (res) {
      callback(res)
    }
  })
}
/* 提交考试信息 */
const submitExamDetail = (param, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/homeworks',
    method: 'POST',
    data: param,
    callback: function (res) {
      callback(res)
    }
  })
}
/* 选课 */
const selectCourse = (cid, sid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/courses/major',
    data: { course_id: cid, semester_id: sid },
    method: 'POST',
    callback: function (res) {
      callback(res)
    }
  })
}
/* 退课 */
const outSelectCourse = (cid, sid, callback) => {
  util.requestApi({
    url: util.config.URL_PATH1 + '/v2/education/courses/drop',
    data: { course_id: cid, semester_id: sid },
    method: 'POST',
    callback: function (res) {
      callback(res)
    }
  })
}
module.exports = {
  getlearnFindList: getlearnFindList,
  getCourseList: getCourseList,
  getCourseDetail: getCourseDetail,
  getCourseAssess: getCourseAssess,
  getExamDetail: getExamDetail,
  submitExamDetail: submitExamDetail,
  selectCourse: selectCourse,
  outSelectCourse: outSelectCourse
}